const host = 'https://i.kunok.com/';
window.normaluser = true;
let userinfo = [];

async function loadusers() {
    try {
        const res = await fetch(`${host}aui.php?action=list`);
        const json = await res.json();
        userinfo = json.data || [];
        console.log('User info loaded:', userinfo);
    } catch (err) {
        console.error('Error loading users:', err);
        userinfo = [];
    }
}

function switchto(id, name, board) {
    window.userid = id;
    console.log(`Switch to ${name} (Board: ${board}), ID: ${id} completed`);
    alert(`Switch to ${name} (Board: ${board}), ID: ${id} completed`);
    window.normaluser = true;
}

function boardcheck(item) {
    try {
        const board = item.board ? JSON.parse(item.board) : {};
        const total = board.totalRequired || 'N/A';
        const answered = board.answeredRequired || 'N/A';
        const bucketTotal = board.bucket_totalRequired || 'N/A';
        const bucketAnswered = board.bucket_answeredRequired || 'N/A';
        const cupTotal = board.cup_totalRequired || 'N/A';
        const cupAnswered = board.cup_answeredRequired || 'N/A';
        const bucketPercent = board.bucket_totalRequired && board.bucket_answeredRequired ? 
            (board.bucket_answeredRequired / board.bucket_totalRequired * 100).toFixed(1) + '%' : 'N/A';
        const cupPercent = board.cup_totalRequired && board.cup_answeredRequired ? 
            (board.cup_answeredRequired / board.cup_totalRequired * 100).toFixed(1) + '%' : 'N/A';
        let progressPercent = 'N/A';
        if (bucketPercent !== 'N/A' && cupPercent !== 'N/A') {
            progressPercent = ((parseFloat(bucketPercent) + parseFloat(cupPercent)) / 2).toFixed(1) + '%';
        } else if (bucketPercent !== 'N/A') {
            progressPercent = (parseFloat(bucketPercent) / 2).toFixed(1) + '%';
        } else if (cupPercent !== 'N/A') {
            progressPercent = (parseFloat(cupPercent) / 2).toFixed(1) + '%';
        }
        
        return `
            <div style="font-size: 12px; color: #666;">
                Total: ${total}, 
                Answered: ${answered}, 
                Progress: ${progressPercent}, 
                Bucket Total: ${bucketTotal}, 
                Bucket Answered: ${bucketAnswered}, 
                Bucket: ${bucketPercent}, 
                Cup Total: ${cupTotal}, 
                Cup Answered: ${cupAnswered}, 
                Cup: ${cupPercent}
            </div>
        `;
    } catch (err) {
        console.error('Error parsing board:', err);
        return `<div style="font-size: 12px; color: #666;">Board Info: Invalid or empty</div>`;
    }
}

async function itemUserList() {
    const defaultAvatar = 'https://placehold.co/40x40/ccc/fff.png?text=?';

    function render(items = []) {
        if (!Array.isArray(items)) return `<div>No data</div>`;
        return `
            <style>
                .itemlist-entry {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    margin-bottom: 10px;
                    padding: 6px;
                    border-bottom: 1px solid #ddd;
                }
                .itemlist-entry img {
                    width: 40px;
                    height: 40px;
                    border-radius: 4px;
                    object-fit: cover;
                }
                .switch-btn {
                    margin-left: auto;
                    padding: 5px 10px;
                    background-color: #007bff;
                    color: white;
                    border: none;
                    border-radius: 4px;
                    cursor: pointer;
                }
                .switch-btn:hover {
                    background-color: #0056b3;
                }
            </style>
            <div>
                ${items.map(item => {
                    const imgSrc = item.board && item.board.trim() !== "" ? item.board : defaultAvatar;
                    const matchedUser = userinfo.find(user => user.id === item.id) || { name: 'N/A', username: 'N/A' };
                    const boardInfo = boardcheck(item);
                    return `
                        <div class="itemlist-entry">
                            <img src="${imgSrc}" onerror="this.src='${defaultAvatar}'" />
                            <div>
                                <div><strong>${item.name}</strong>, ${matchedUser.name} (${matchedUser.username})</div>
                                <div style="font-size: 12px; color: #666;">
                                    IDA: ${item.ida}, ID: ${item.id}, Timestamp: ${item.timestamp}
                                </div>
                                ${boardInfo}
                            </div>
                            <button class="switch-btn" onclick="switchto('${item.id}', '${item.name}', '${item.board || 'N/A'}')">Switch</button>
                        </div>
                    `;
                }).join("")}
            </div>
        `;
    }

    try {
        await loadusers(); // Load userinfo before rendering
        const res = await fetch(`${host}api622.php?action=list_all&fields=ida,id,name,flag,timestamp,board`);
        const json = await res.json();

        let items = json.data || [];

        if (window.normaluser) {
            items = items.filter(item => Number(item.ida) > 576 && Number(item.flag) === 1);
        }

        // Calculate progressPercent for each item and log summaries
        let totalCount = items.length;
        let progressCount = 0;
        let notActiveCount = 0;
        let doneCount = 0;
        let inProgressCount = 0;

        items.forEach(item => {
            let progressPercent = 'N/A';
            try {
                const board = item.board ? JSON.parse(item.board) : {};
                const bucketPercent = board.bucket_totalRequired && board.bucket_answeredRequired ? 
                    (board.bucket_answeredRequired / board.bucket_totalRequired * 100) : null;
                const cupPercent = board.cup_totalRequired && board.cup_answeredRequired ? 
                    (board.cup_answeredRequired / board.cup_totalRequired * 100) : null;

                if (bucketPercent !== null && cupPercent !== null) {
                    progressPercent = (bucketPercent + cupPercent) / 2;
                } else if (bucketPercent !== null) {
                    progressPercent = bucketPercent / 2;
                } else if (cupPercent !== null) {
                    progressPercent = cupPercent / 2;
                }

                if (progressPercent !== 'N/A' && progressPercent > 0) {
                    progressCount++;
                    if (Math.abs(progressPercent - 100) < 0.01) {
                        doneCount++;
                    } else {
                        inProgressCount++;
                    }
                } else if (progressPercent === 'N/A') {
                    notActiveCount++;
                }
            } catch (err) {
                console.error('Error parsing board for summary:', err);
                notActiveCount++;
            }
        });

        // Calculate percentages
        const progressPercentOfTotal = totalCount > 0 ? ((progressCount / totalCount) * 100).toFixed(1) + '%' : '0%';
        const notActivePercentOfTotal = totalCount > 0 ? ((notActiveCount / totalCount) * 100).toFixed(1) + '%' : '0%';
        const donePercentOfTotal = totalCount > 0 ? ((doneCount / totalCount) * 100).toFixed(1) + '%' : '0%';
        const inProgressPercentOfTotal = totalCount > 0 ? ((inProgressCount / totalCount) * 100).toFixed(1) + '%' : '0%';

        // Log summaries
        console.log(`Total items: ${totalCount}`);
        console.log(`Total items with progress% > 0: ${progressCount}`);
        console.log(`Total not active items: ${notActiveCount}`);
        console.log(`Percent with progress: ${progressPercentOfTotal}`);
        console.log(`Percent not active: ${notActivePercentOfTotal}`);
        console.log(`Total items Done (Progress% = 100): ${doneCount}`);
        console.log(`Total items inProgress (0 < Progress% < 100): ${inProgressCount}`);
        console.log(`Percent Done: ${donePercentOfTotal}`);
        console.log(`Percent inProgress: ${inProgressPercentOfTotal}`);

        // Sort items by progressPercent in descending order
        items.sort((a, b) => {
            let aProgress = 'N/A';
            let bProgress = 'N/A';
            try {
                const aBoard = a.board ? JSON.parse(a.board) : {};
                const bBoard = b.board ? JSON.parse(b.board) : {};
                const aBucketPercent = aBoard.bucket_totalRequired && aBoard.bucket_answeredRequired ? 
                    (aBoard.bucket_answeredRequired / aBoard.bucket_totalRequired * 100) : null;
                const aCupPercent = aBoard.cup_totalRequired && aBoard.cup_answeredRequired ? 
                    (aBoard.cup_answeredRequired / aBoard.cup_totalRequired * 100) : null;
                const bBucketPercent = bBoard.bucket_totalRequired && bBoard.bucket_answeredRequired ? 
                    (bBoard.bucket_answeredRequired / bBoard.bucket_totalRequired * 100) : null;
                const bCupPercent = bBoard.cup_totalRequired && bBoard.cup_answeredRequired ? 
                    (bBoard.cup_answeredRequired / bBoard.cup_totalRequired * 100) : null;

                if (aBucketPercent !== null && aCupPercent !== null) {
                    aProgress = (aBucketPercent + aCupPercent) / 2;
                } else if (aBucketPercent !== null) {
                    aProgress = aBucketPercent / 2;
                } else if (aCupPercent !== null) {
                    aProgress = aCupPercent / 2;
                }

                if (bBucketPercent !== null && bCupPercent !== null) {
                    bProgress = (bBucketPercent + bCupPercent) / 2;
                } else if (bBucketPercent !== null) {
                    bProgress = bBucketPercent / 2;
                } else if (bCupPercent !== null) {
                    bProgress = bCupPercent / 2;
                }
            } catch (err) {
                console.error('Error parsing board for sorting:', err);
            }

            if (aProgress === 'N/A' && bProgress === 'N/A') return 0;
            if (aProgress === 'N/A') return 1;
            if (bProgress === 'N/A') return -1;
            return bProgress - aProgress;
        });

        const html = render(items);

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include panel system.");
            return;
        }

        createPanel("itemUserList", "CC", "ctc", 500, 600, {
            bodyContent: html,
            
            title: window.normaluser ? "Item & User List " : "Item User List",
            resizeAble: true
        });

    } catch (err) {
        console.error("Error loading item user list:", err);
        createPanel("itemUserList", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">${err.message}</div>`,
            noFooter: true,
            title: "Item User List"
        });
    }
}