window.normaluser=true;
async function userListPanel() { 
    const defaultAvatar = 'https://placehold.co/40x40/ccc/fff.png?text=?';

    function render(users = []) {
        if (!Array.isArray(users)) return `<div>No data</div>`;
        return `
            <style>
                .userlist-entry {
                    display: flex;
                    align-items: center;
                    gap: 10px;
                    margin-bottom: 10px;
                    padding: 6px;
                    border-bottom: 1px solid #ddd;
                }
                .userlist-entry img {
                    width: 40px;
                    height: 40px;
                    border-radius: 4px;
                    object-fit: cover;
                }
            </style>
            <div>
                ${users.map(user => {
                    const imgSrc = user.img && user.img.trim() !== "" ? user.img : defaultAvatar;
                    return `
                        <div class="userlist-entry">
                            <img src="${imgSrc}" onerror="this.src='${defaultAvatar}'" />
                            <div>
                                <div><strong>${user.name}</strong> (${user.username})</div>
                                <div style="font-size: 12px; color: #666;">
                                    IDA: ${user.ida}, ID: ${user.id}, Password: ${user.password}
                                </div>
                            </div>
                        </div>
                    `;
                }).join("")}
            </div>
        `;
    }

    try {
        const res = await fetch("https://j.kunok.com/aui.php?action=list");
        const json = await res.json();

        let users = json.data || [];

        // ✅ apply condition if window.normaluser is true
        if (window.normaluser) {
            users = users.filter(u => Number(u.ida) > 43 && Number(u.flag) === 1);
        }

        const html = render(users);

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel(). Please include panel system.");
            return;
        }

        createPanel("userListPanel", "CC", "ctc", 500, 600, {
            bodyContent: html,
            noFooter: true,
            title: window.normaluser ? "User List (Normal Users)" : "User List"
        });

    } catch (err) {
        console.error("Error loading user list:", err);
        createPanel("userListPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="message error">${err.message}</div>`,
            noFooter: true,
            title: "User List"
        });
    }
}

