function toggleLogonoff(id) {
  const toggleEl = document.getElementById(id);
  if (!toggleEl) {
    console.warn(`Element with id ${id} not found`);
    return;
  }

  const isLoggedIn = localStorage.getItem('logged') === 'true';
  if (isLoggedIn) {
    // Log out
    localStorage.setItem('logged', 'false');
    localStorage.removeItem('userid');
    localStorage.removeItem('user');
    localStorage.removeItem('user_name');
    localStorage.removeItem('flag');
    localStorage.removeItem('level');
    localStorage.removeItem('img');
    localStorage.removeItem('user_startDateTime');
    localStorage.removeItem('password');
    toggleEl.textContent = 'Log On';
    console.log('User logged out');
    location.href = 'login.html';
  } else {
    // Log in (redirect to login page)
    toggleEl.textContent = 'Log On';
    console.log('Redirecting to login page');
    location.href = 'login.html';
  }
}

function initLoginToggle() {
  const toggleEl = document.getElementById('loginToggle');
  if (toggleEl) {
    const isLoggedIn = localStorage.getItem('logged') === 'true';
    toggleEl.textContent = isLoggedIn ? 'Log Off' : 'Log On';
    toggleEl.addEventListener('click', () => {
      console.log('loginToggle clicked');
      toggleLogonoff('loginToggle');
    });
  } else {
    console.warn('loginToggle element not found');
  }
}

// Initialize on load
window.addEventListener('load', initLoginToggle);