const testItemsArray = [
    {
        id: "1",
        name: "Test Item 1",
        flag: "active",
        timestamp: "2025-08-06T12:00:00Z",
        board: JSON.stringify({ user: "testUser1", details: "Sample board data" }),
        keeper: "Keeper1"
    },
    {
        id: "2",
        name: "Test Item 2",
        flag: "inactive",
        timestamp: "2025-08-06T12:01:00Z",
        board: JSON.stringify({ user: "testUser2", details: "Another board data" }),
        keeper: "Keeper2"
    }
];
let testItems = [
    {
        id: "1",
        name: "Test Item 1",
        flag: "active",
        timestamp: "2025-08-06T12:00:00Z",
        board: JSON.stringify({ user: "testUser1", details: "Sample board data" }),
        keeper: "Keeper1"
    },
    {
        id: "2",
        name: "Test Item 2",
        flag: "inactive",
        timestamp: "2025-08-06T12:01:00Z",
        board: JSON.stringify({ user: "testUser2", details: "Another board data" }),
        keeper: "Keeper2"
    }
];
function consoleUIRawItems(divId) {
    const div = document.getElementById(divId);
    if (!div) {
        console.error(`Div with ID "${divId}" not found`);
        return;
    }

    const html = `
        <style>
            .raw-data {
                background: #f5f5f5;
                padding: 12px;
                border-radius: 6px;
                margin-bottom: 10px;
                font-size: 14px;
                white-space: pre-wrap;
                font-family: monospace;
                max-height: 300px;
                overflow-y: auto;
            }
        </style>
        <div class="raw-data">
            <strong>testItemsArray:</strong>
            <pre>${JSON.stringify(testItemsArray, null, 2)}</pre>
            <strong>testItems:</strong>
            <pre>${JSON.stringify(testItems, null, 2)}</pre>
        </div>
    `;

    div.innerHTML = html;
}
function testConsoleUIRawItems() {
    try {
        if (typeof createPanel !== "function") {
            console.error("Missing createPanel() from micro2.js");
            return;
        }

        const divId = "testConsoleUIRawItemsContent";
        const html = `<div id="${divId}"></div>`;

        createPanel("testConsoleUIRawItemsPanel", "CC", "ctc", 600, 400, {
            bodyContent: html,
            noFooter: true,
            title: "Test Console UI Raw Items"
        });

        setTimeout(() => {
            console.log("Testing consoleUIRawItems...");
            consoleUIRawItems(divId);
            console.log("Test completed for consoleUIRawItems.");
        }, 100);
    } catch (err) {
        console.error("Error testing consoleUIRawItems:", err);
        createPanel("testConsoleUIRawItemsPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="error">${err.message}</div>`,
            noFooter: true,
            title: "Test Console UI Raw Items"
        });
    }
}