/* ========= Avatar-aware Tiny Draggable Pill ========= */
(() => {
  const ID = 'tinyListener';
  if (document.getElementById(ID)) return;

  /* 1️⃣  Re-use your avatar logic */
  const user_imgr = localStorage.getItem("img") || "";
  let user_img = "https://i.pravatar.cc/40?u=yanyong";   // fallback
  try {
    if (user_imgr) user_img = atob(user_imgr);
  } catch (e) {
    console.warn("Invalid base64 image, using default:", e);
  }

  /* 2️⃣  pill shell */
  const pill = document.createElement('div');
  pill.id = ID;
  pill.innerHTML = `
    <img class="avatar" id="pillAvatar" src="" alt=" ">
    <div class="dot" data-action="menu" title="Toggle menu">●</div>
    <div class="dot" data-action="close" title="Close pill">●</div>
  `;
  document.body.appendChild(pill);

  /* 3️⃣  inject avatar */
  pill.querySelector('#pillAvatar').src = user_img;

  /* 4️⃣  styles (unchanged) */
  addStyle(`
    #tinyListener{
      position:fixed; left:8px; bottom:8px;
      display:flex; align-items:center; gap:6px;
      padding:4px 8px 4px 4px;
      background:rgba(30,30,30,.75);
      color:#fff; border-radius:20px;
      font-size:14px; cursor:grab; user-select:none;
      z-index:9999; transition:transform .2s;
    }
    #tinyListener:active{cursor:grabbing;}
    #tinyListener .avatar{width:24px;height:24px;border-radius:50%;display:block;}
    #tinyListener .dot{font-size:18px; cursor:pointer;}
    #tinyListener .dot:hover{transform:scale(1.25);}
  `);

  /* 5️⃣  drag & click logic (same as before) */
  let dragOffsetX = 0, dragOffsetY = 0, isDragging = false;
  pill.addEventListener('mousedown', start);
  pill.addEventListener('touchstart', start, {passive:false});

  function start(e){
    if (e.target.classList.contains('dot')) return;
    e.preventDefault();
    const r = pill.getBoundingClientRect();
    const cX = e.touches ? e.touches[0].clientX : e.clientX;
    const cY = e.touches ? e.touches[0].clientY : e.clientY;
    dragOffsetX = cX - r.left;
    dragOffsetY = cY - r.top;
    isDragging = true;

    document.addEventListener('mousemove', move);
    document.addEventListener('mouseup', stop);
    document.addEventListener('touchmove', move, {passive:false});
    document.addEventListener('touchend', stop);
  }
  function move(e){
    if (!isDragging) return;
    const cX = e.touches ? e.touches[0].clientX : e.clientX;
    const cY = e.touches ? e.touches[0].clientY : e.clientY;
    pill.style.left = (cX - dragOffsetX) + 'px';
    pill.style.bottom = 'auto';
    pill.style.top  = (cY - dragOffsetY) + 'px';
  }
  function stop(){
    isDragging = false;
    ['mousemove','mouseup','touchmove','touchend']
      .forEach(evt => document.removeEventListener(evt, move));
  }
// Add to avatar.js
function updateBottomBarAvatar() {
  const user_imgr = localStorage.getItem("img") || "";
  let user_img = "https://i.pravatar.cc/40?u=yanyong"; // Fallback
  try {
    if (user_imgr) user_img = atob(user_imgr);
  } catch (e) {
    console.warn("Invalid base64 image for bottom bar avatar, using default:", e);
  }
  const avatarEl = document.getElementById('avatar');
  if (avatarEl) {
    avatarEl.src = user_img;
    avatarEl.alt = "User Avatar";
  } else {
    console.warn("Bottom bar avatar element (#avatar) not found");
  }
}
window.updateBottomBarAvatar = updateBottomBarAvatar; // Expose globally
  pill.addEventListener('click', e => {
    const act = e.target.dataset.action;
    if (act === 'menu') toggleLeftMenu?.();
    if (act === 'close') pill.remove();
  });
})();