(function () {
  // Inject styles
  const css = `  
    .menuGroup { margin-bottom: 6px; } /* Reduced from 10px */
    .groupTitle {
//    font-weight: bold;
    font-size: 13px; /* Reduced from 14px */
    margin-bottom: 3px; /* Reduced from 5px */
    color:rgba(20,20,20,.3);
    padding-left: 4px;
  }
    .menuButton {
    background: rgba(255,255,255,.8);
    border-radius: 4px; /* Reduced from 6px */
    padding: 6px 8px; /* Reduced from 8px 12px */
    margin-bottom: 2px; /* Reduced from 4px */
    font-size: 12px; /* Reduced from 13px */
    cursor: pointer;
    position: relative;
    display: flex;
    flex-direction: column;
   
        
  }
    
     .menuTop {
    display: flex;
    gap: 6px; /* Reduced from 8px */
    align-items: center;
  }
    
    .statusLabel {
    font-size: 10px; /* Reduced from 11px */
    margin-left: 22px; /* Reduced from 26px */
    margin-bottom: 2px; /* Reduced from 4px */
  }
    .statusLabel[data-status="done"]    { color: green; }
    .statusLabel[data-status="pending"] { color: orange; }
    .statusLabel[data-status="start"]   { color: gray; }
    .statusLabel[data-status="in progress"] { color: dodgerblue; }
    .progressBar {
     height: 4px; /* Reduced from 6px */
    margin-bottom: 2px; /* Reduced from 4px */
      background: #ddd;
      border-radius: 3px;
      overflow: hidden;
      margin-left: 0px;
      margin-right: 0px;
      
    }
    .progressInner {
      height: 100%;
      background: #007bff;
      width: 0%;
      transition: width 0.3s;
    }
   
    
    .bottomBar {
      margin-top: 20px;
      display: flex;
      flex-direction: column;
       margin-top: 12px; /* Reduced from 20px */
    gap: 4px; /* Reduced from 8px */
    }
    .statusDisplay {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 12px;
      background: #fff;
      padding: 5px 8px;
      border-radius: 5px;
      color: #333;
      gap: 8px;
    }
    .statusDot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
    }
    .greenDot { background: green; }
    .redDot { background: red; }
    .bottomRowA {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 5px 8px;
      background: #fff;
      border-radius: 5px;
    }
    #avatar {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: url('https://i.pravatar.cc/24') no-repeat center;
      background-size: cover;
    }
    #loginToggle {
      font-size: 12px;
      cursor: pointer;
      color: #007BFF;
    }
    .menufooter {
      display: flex;
      flex-direction: column;
      gap: 8px;
    }
    .badge {
    position: absolute;  
  
  text-align: center;  
  color: white;
  border-radius: 7px;
    right: 1px; /* Reduced from 4px */
    top: 1px; /* Reduced from 4px */
    min-width: 12px; /* Reduced from 14px */
    height: 12px; /* Reduced from 14px */
    padding: 0 2px; /* Reduced from 3px */
    font-size: 9px; /* Reduced from 9px */
    line-height: 12px; /* Adjusted */
    border-radius: 6px; /* Reduced from 7px */
  }
    .badge-text {
    top: 1px; /* Reduced from 4px */
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      max-width: 50px;
       position: relative;
  top: 1px; /* Pull text up slightly more than numbers */
    }
    
    
    .statusDisplay, .bottomRow {
    padding: 3px 8px; /* Reduced from 5px 8px */
    background:rgba(100,100,100,.2);
  }
    .menuButton {
  padding-right: 18px; /* Reduced from 20px */
}
 .lang-switcher-slide {
    display: inline-flex;
    align-items: center;
    padding: 4px 8px;
    background: #f0f0f0;
    border-radius: 12px;
    cursor: pointer;
    transition: background 0.3s;
    position: relative;
    overflow: hidden;
}

.lang-option {
    padding: 0 8px;
    font-size: 12px;
    color: #333;
    cursor: pointer;
    position: absolute;
    width: 50%;
    height: 100%;
    display: flex;
    align-items: center;
    justify-content: center;
}

.lang-option:nth-child(1) {
    left: 0;
}

.lang-option:nth-child(2) {
    left: 50%;
}

.lang-slide-indicator {
    position: absolute;
    width: 50%;
    height: 100%;
    background: #007bff;
    border-radius: 20px;
    transition: transform 0.3s;
    z-index: 1;
    top: 0;
    left: 0;
}

.lang-switcher-slide.active .lang-slide-indicator {
    transform: translateX(100%);
    background: #28a745;
}
    .bottomBar {
    position: fixed; /* or position: absolute; depending on context */
    bottom: 0;
    left: 0;
    right: 0;
    margin-top: 12px;
    display: flex;
    flex-direction: column;
    gap: 4px;
    background: #fff; /* Ensure visibility */
    padding: 8px;
    z-index: 1000; /* Ensure it stays above other elements */
}
  `;
  const style = document.createElement('style');
  style.textContent = css;
  document.head.appendChild(style);

  // Menu Data
  const menuData = [{
    group: "Main",
    items: [
      {
        item: "A1",
        icon: "💎",
        text: "KTB2025",
        badge: { value: "NEW", color: "#ff5722" },
        progress: 50,
        status: "Welcome",
        onclick: () => loadAndUpdateSummaries(userid)
      }
    ]
  },
  {
    group: "Tracking",
    items: [
      {
        item: "assessment",
        icon: "📦",
        text: "Assessment",
                badge: { value: "", color: "#ff5722" },

        status: "start",
        progress: 50,
        onclick: () => { PanelTR(); genpaN(userid) }
      },
      {
        item: "Profile",
        icon: "💳",
        text: "Profile",
        badge: { value: "", color: "#ff5722" },
        status: "start",
        progress: 10,
        onclick: () => { PanelTR(); profilepaN(userid) }
      }
    ]
  },
  {
    group: "Actions",
    items: [
      {
        item: "save",
        icon: "💾",
        text: "Save",
        badge: { value: 0 },
        onclick: () => saveToServerM(userid)
      }
    ]
  }, {
    group: "User Actions",
    items: [
      {
        item: "profilez",
        icon: "👤",
        text: "User",
        badge: { value: 0, color: "#4caf50" },
        onclick: () => showUserUpdatePanel()
      },
      {
        item: "mypanel",
        icon: "⚙️",
        text: "my",
        badge: { value: 0, color: "#f44336" },
        onclick: () => {loadAndUpdateGS(userid);renderCupToDivProfileML(userid);}
      },

    ]
  }];

  

  

  function renderMenu(showIcons = true, showBadges = true) {
    //const bar = document.getElementById('smartBarIn');
    const bar = document.getElementById('menuItems'); // Change to menuItems
    if (bar) bar.innerHTML = '';
    menuData.forEach(group => {
      const groupDiv = document.createElement('div');
      groupDiv.className = 'menuGroup';
      const title = document.createElement('div');
      title.className = 'groupTitle';
      title.textContent = group.group;
      groupDiv.appendChild(title);
      group.items.forEach(item => {
        const btn = document.createElement('div');
        btn.className = 'menuButton';
        btn.id = item.item;
        const topRow = document.createElement('div');
        topRow.className = 'menuTop';
        
        // Build badge HTML if needed
        let badgeHtml = '';
        if (showBadges && item.badge) {
          const badgeValue = item.badge.value;
          const badgeColor = item.badge.color || '#007bff';
          const displayValue = badgeValue !== undefined && badgeValue !== null && badgeValue !== '' ? badgeValue : '';
          
          badgeHtml = `
            <span class="badge" id="badge_${item.item}" 
                  style="background-color: ${badgeColor}; display: ${displayValue ? 'inline-block' : 'none'}">
              <span class="badge-text">${displayValue}</span>
            </span>
          `;
        }
        
        topRow.innerHTML = `
  ${showIcons ? `<span class="icon">${item.icon || ''}</span>` : ''}
  <span class="labelText">${item.text || item.item}</span>
  ${showBadges && item.badge ? `
    <span class="badge" id="badge_${item.item}" 
          style="background-color: ${item.badge.color || '#007bff'}; 
                 display: ${item.badge.value ? 'inline-block' : 'none'}">
      ${item.badge.value || ''}
    </span>
  ` : ''}
`;
        btn.appendChild(topRow);
        
        if (item.status) {
          const status = document.createElement('div');
          status.className = 'statusLabel';
          status.id = `status_${item.item}`;
          status.dataset.status = item.status.toLowerCase();
          status.textContent = item.status;
          btn.appendChild(status);
        }
        
        if (typeof item.progress === 'number') {
          const progressBar = document.createElement('div');
          progressBar.className = 'progressBar';
          const inner = document.createElement('div');
          inner.className = 'progressInner';
          inner.style.width = item.progress + '%';
          inner.id = `progress_${item.item}`;
          progressBar.appendChild(inner);
          btn.appendChild(progressBar);
        }
        
        if (item.checklist) {
          const checkDiv = document.createElement('div');
          checkDiv.className = 'checklistItem';
          const checkbox = document.createElement('input');
          checkbox.type = 'checkbox';
          checkbox.checked = !!item.checked;
          checkbox.id = `check_${item.item}`;
          checkbox.addEventListener('change', () => {
            item.checked = checkbox.checked;
            alert(`Checklist ${item.item}: ${checkbox.checked ? 'Done' : 'Not Done'}`);
          });
          const label = document.createElement('label');
          label.textContent = 'Complete?';
          label.htmlFor = checkbox.id;
          checkDiv.appendChild(checkbox);
          checkDiv.appendChild(label);
          btn.appendChild(checkDiv);
        }
        
        if (typeof item.onclick === 'function') {
          btn.addEventListener('click', item.onclick);
        }
        
        groupDiv.appendChild(btn);
        if (item.badge) {
          updateBadge(item.item, item.badge.value, item.badge.color);
        }
      });
      if (bar)       bar.appendChild(groupDiv);
    });
  }

  function updateBadge(id, value, color = '#007bff') {
    const badge = document.getElementById(`badge_${id}`);
    if (!badge) return;
    
    const displayValue = value !== undefined && value !== null && value !== '' ? value : '';
    badge.innerHTML = `<span class="badge-text">${displayValue}</span>`;
    badge.style.display = displayValue ? 'inline-block' : 'none';
    badge.style.backgroundColor = color;
    
    // Adjust styling for non-numeric badges
    if (typeof value !== 'number') {
      badge.style.minWidth = 'auto';
      badge.style.padding = '0 6px';
    }
  }

  function updateProgress(id, percent) {
    const progress = document.getElementById(`progress_${id}`);
    if (progress) {
      const clamped = Math.min(percent, 100);
      progress.style.width = `${clamped}%`;
      progress.title = `${percent}%`;
    }
  }

  function updateStatus(id, status) {
    const div = document.getElementById(`status_${id}`);
    if (div) {
      div.textContent = status;
      div.dataset.status = status.toLowerCase();
    }
  }

  function updateChecklist(id, checked) {
    const box = document.getElementById(`check_${id}`);
    if (box) box.checked = checked;
  }

  function updateItemText(id, newText) {
    const item = document.querySelector(`#${id} .labelText`);
    if (item) {
      item.textContent = newText;
    }
  }

  // Language switcher functions
let isToggling = false;
function toggleLang() {
  if (isToggling) return;
  isToggling = true;
  console.log('toggleLang called');
  const currentLang = localStorage.getItem('language') || 'en';
  const newLang = currentLang === 'en' ? 'th' : 'en';
  setLanguage(newLang);
  switchLang(newLang);
  setTimeout(() => { isToggling = false; }, 300); // Match animation duration
}

function setLanguage(lang) {
    localStorage.setItem('language', lang);
    window.lang = lang; // Sync window.lang
    updateSwitch(lang);
    console.log('Language set to:', lang);
}

// In kkk.js, replace updateSwitch
function updateSwitch(lang, retries = 3, delay = 100) {
  console.log('Updating switch for language:', lang); // Debug
  const switchEl = document.getElementById('slideSwitch') || document.querySelector('.lang-switcher-slide');
  if (switchEl) {
    switchEl.classList.toggle('active', lang === 'th');
    const indicator = switchEl.querySelector('.lang-slide-indicator');
    if (indicator) {
      indicator.style.transform = lang === 'th' ? 'translateX(100%)' : 'translateX(0)';
    }
  } else if (retries > 0) {
    console.warn(`slideSwitch not found, retrying (${retries} attempts left)`);
    setTimeout(() => updateSwitch(lang, retries - 1, delay), delay);
  } else {
    console.warn('slideSwitch or lang-switcher-slide element not found after retries');
  }
}

  function switchLang_01(lang) {
    window.lang = lang;
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    (window.formStack || []).forEach((panelId) => {
      if (panelId === "gen" && typeof genpaN === "function") genpaN(window.userid);
      else if (panelId === "profile" && typeof profilepaN === "function") profilepaN(window.userid);
    });

    if (document.getElementById("summan") && typeof renderSchemaStructureToSumman === "function") {
      renderSchemaStructureToSumman(window.bucket, "gform", lang);
    }

    if (document.getElementById("jumperhelper") && typeof updateJumperHelperWithUnanswered === "function") {
      updateJumperHelperWithUnanswered(QSummary(window.bucket).summary, window.bucket);
    }
  }
function switchLang_02_no_cache(lang) {
        // Set the new language
        window.lang = lang;

        // Update UI language buttons
        document.querySelectorAll(".lang-btn").forEach((btn) => {
            btn.classList.toggle("active", btn.dataset.lang === lang);
        });

        // Refresh all forms in the stack using smart loading
        formStack.forEach((panelId) => {
            if (panelId === "gen" || panelId === "profile") {
                // Try to load from localStorage first
               
                    // Fall back to server if no cached data
                    console.log(`⚡ No cached data, loading ${panelId} from server`);
                    if (panelId === "gen") genpaN(userid);
                    else if (panelId === "profile") profilepaN(userid);
               
            }
        });

        // Update summary panels
        updateSummaryPanels(lang);
    }
    function switchLangXX(lang) {
   // Store original setting
    const originalLoadSetting = window.loadFromLocalStorage;
    
    // Force localStorage-only mode for language switching
    window.loadFromLocalStorage = true;
    // Set the new language
        window.lang = lang;

        // Update UI language buttons
        document.querySelectorAll(".lang-btn").forEach((btn) => {
            btn.classList.toggle("active", btn.dataset.lang === lang);
        });

        // Refresh all forms in the stack using smart loading
        formStack.forEach((panelId) => {
            if (panelId === "gen" || panelId === "profile") {
                // Try to load from localStorage first
               
                    // Fall back to server if no cached data
                    console.log(`⚡ No cached data, loading ${panelId} from server`);
                    if (panelId === "gen") genpaN(userid);
                    else if (panelId === "profile") profilepaN(userid);
               
            }
        });
  // Restore original setting
    window.loadFromLocalStorage = originalLoadSetting;
    // Update summary panels
    updateSummaryPanels(lang);
}
function switchLang(lang) {
  const originalLoadSetting = window.loadFromLocalStorage;
  window.loadFromLocalStorage = true;

  window.lang = lang;
  localStorage.setItem('language', lang);

  document.querySelectorAll('.lang-btn').forEach((btn) => {
    btn.classList.toggle('active', btn.dataset.lang === lang);
  });

  (window.formStack || []).forEach((panelId) => {
    if (panelId === 'gen' && typeof genpaN === 'function') {
      window.loadFromLocalStorage
        ? processCachedDataFromLocalStorage('gen', 'gform', 'bucket')
        : genpaN(window.userid);
    } else if (panelId === 'profile' && typeof profilepaN === 'function') {
      window.loadFromLocalStorage
        ? processCachedDataFromLocalStorage('profile', 'pro', 'cup')
        : profilepaN(window.userid);
    }
  });

  if (document.getElementById('summan') && typeof renderSchemaStructureToSumman === 'function') {
    renderSchemaStructureToSumman(window.bucket, 'gform', lang);
  }

  if (document.getElementById('jumperhelper') && typeof updateJumperHelperWithUnanswered === 'function') {
    updateJumperHelperWithUnanswered(QSummary(window.bucket).summary, window.bucket);
  }

  window.loadFromLocalStorage = originalLoadSetting;
  updateSwitch(lang);
}
  // Expose functions to window
  window.updateProgress = updateProgress;
  window.updateStatus = updateStatus;
  window.updateItemText = updateItemText;
  window.updateBadge = updateBadge;
  window.renderMenu = renderMenu;
  window.toggleLang = toggleLang;
  window.setLanguage = setLanguage;
window.updateSwitch = updateSwitch;
window.switchLang = switchLang; // Add this line
  window.clearAllBadges = function () {
    document.querySelectorAll('.badge').forEach(badge => {
      badge.textContent = '';
      badge.style.display = 'none';
    });
  };

  // Initialize
  renderMenu();
// In kkk.js, update initLanguage
window.initLanguage = function () {
  const initialLang = localStorage.getItem('language') || 'en';
  setLanguage(initialLang);
  const slideSwitch = document.getElementById('slideSwitch');
  if (slideSwitch) {
    console.log('Attaching click event listener to slideSwitch');
    slideSwitch.addEventListener('click', () => {
      console.log('slideSwitch clicked, triggering toggleLang');
      toggleLang();
    });
  } else {
    console.warn('slideSwitch not found during initLanguage');
  }
};
//  already existing exports ...

window.clearAllBadges = clearAllBadges;    
    
})();