function countFiles(field) {
  if (!field || !field.value) return 0;

  // Handle direct string value (for radiotextatt.att)
  if (typeof field.value === "string") {
    return field.value.split(",").filter((f) => f.trim()).length;
  }

  // Handle attachment type
  if (field.data_type === "attachment" && typeof field.value === "string") {
    return field.value.split(",").filter((f) => f.trim()).length;
  }

  // Handle radiotextatt type
  if (
    field.data_type === "radiotextatt" &&
    field.value?.att &&
    typeof field.value.att === "string"
  ) {
    return field.value.att.split(",").filter((f) => f.trim()).length;
  }

  return 0;
}

function isFieldAnswered(field) {
  const inputType = field.data_type || field.type;
  if (inputType === "checkbox") {
    return Array.isArray(field.value) && field.value.length > 0;
  } else if (inputType === "radio" || inputType === "select") {
    return field.value !== null && field.value !== "";
  } else if (inputType === "attachment") {
    return field.value && countFiles(field) > 0;
  } else {
    return field.value !== null && field.value !== "";
  }
}

function encodeFieldKey(key) {
  return key; // Assume simple pass-through; replace with actual implementation if needed
}

function getLabel(field, lang) {
  return field.label?.[lang] || field.label?.en || key;
}

function calculateCurrentScore(field) {
  if (!isFieldAnswered(field)) return 0;
  if (field.weights && field.value !== null) {
    // Handle radiotext and radiotextatt
    if (field.data_type === "radiotext" || field.data_type === "radiotextatt") {
      return field.weights[field.value.radio] || 0;
    }
    // Handle other types...
  }
  return field.score || 1;
}

function calculateMaxScore(field) {
  if (field.weights) {
    return Math.max(...field.weights) || 1;
  }
  return field.score || 1;
}

function getOptions(field, lang) {
  return field.options?.[lang] || field.options?.en || [];
}
function scrollToField(key, divId = "genform") {
  let encodedKey = encodeFieldKey(key);
  let element = document.getElementById(`${divId}-field-${encodedKey}`);

  if (!element)
    element = document.getElementById(`${divId}-section-${encodedKey}`);
  if (!element)
    element = document.getElementById(`${divId}-segment-${encodedKey}`);

  if (element) {
    element.scrollIntoView({ behavior: "smooth", block: "center" });
    element.style.backgroundColor = "#e0f7fa";
    setTimeout(() => {
      element.style.backgroundColor = "";
    }, 2000);
  } else {
    console.warn(`Element with key ${key} not found for scrolling`);
  }
}
