
(function () {
  function createProgressBar(div, options = {}) {
    if (div._initialized) return;

    const isVertical = options.vertical || false;
    const showText = options.text !== false;
    const reverse = options.reverse || false;
    const fillColor = options.fillColor || "#4caf50";

    div.style.position = "relative";
    div.style.background = "#ddd";
    div.style.borderRadius = "4px";
    div.style.overflow = "hidden";

    const fill = document.createElement("div");
    fill.style.background = fillColor;
    fill.style.transition = isVertical ? "height 0.3s" : "width 0.3s";
    fill.style.position = "absolute";

    if (isVertical) {
      fill.style.bottom = reverse ? "auto" : "0";
      fill.style.top = reverse ? "0" : "auto";
      fill.style.left = "0";
      fill.style.right = "0";
      fill.style.height = "0%";
    } else {
      fill.style.left = reverse ? "auto" : "0";
      fill.style.right = reverse ? "0" : "auto";
      fill.style.top = "0";
      fill.style.bottom = "0";
      fill.style.width = "0%";
    }

    div.appendChild(fill);

    let label = null;
    if (showText) {
      label = document.createElement("div");
      label.style.position = "absolute";
      label.style.top = "0";
      label.style.left = "0";
      label.style.width = "100%";
      label.style.height = "100%";
      label.style.display = "flex";
      label.style.alignItems = "center";
      label.style.justifyContent = "center";
      label.style.fontSize = "12px";
      label.style.fontFamily = "sans-serif";
      label.style.color = "#000";
      div.appendChild(label);
    }

    div._fill = fill;
    div._label = label;
    div._vertical = isVertical;
    div._reverse = reverse;
    div._text = showText;
    div._initialized = true;
  }

  function ProgressBar(divId, percent, options = {}) {
    const div = typeof divId === "string" ? document.getElementById(divId) : divId;
    if (!div) return;

    createProgressBar(div, options);
    const clamped = Math.min(Math.max(percent, 0), 100);

    if (div._vertical) {
      div._fill.style.height = clamped + "%";
    } else {
      div._fill.style.width = clamped + "%";
    }

    if (div._text && div._label) {
      div._label.textContent = clamped + "%";
    }

    div.title = clamped + "%";
  }

  window.ProgressBar = ProgressBar;
})();
