function showSmartUserStatus(
  user = "Johnny",
  avatarURL = "https://via.placeholder.com/32",
) {
  if (!document.body) {
    const body = document.createElement("body");
    document.documentElement.appendChild(body);
  }

  const existing = document.getElementById("smartUserStatus");
  if (existing) existing.remove();

  const box = document.createElement("div");
  box.id = "smartUserStatus";
  box.style.position = "absolute";
  box.style.left = "-400px"; // Off screen
  box.style.top = localStorage.getItem("smartStatusY") || "calc(100% - 80px)";
  box.style.padding = "6px 12px";
  box.style.borderRadius = "12px";
  //box.style.color = "#fff";
  box.style.fontSize = "14px";
  box.style.backdropFilter = "blur(20px)";
  box.style.background = "rgba(0,0,0,0.01)";
  box.style.boxShadow = "0 4px 12px rgba(0,0,0,0.3)";
  box.style.zIndex = "9999";
  box.style.transition = "all 0.3s ease";
  box.style.transform = "scale(1)";
  box.style.opacity = "0";
  box.style.display = "flex";
  box.style.alignItems = "center";
  box.style.gap = "8px";
  box.style.userSelect = "none";
  box.style.cursor = "move";
  box.style.maxWidth = "max-content";

  // 🟦 Blue button (toggle)
  const blueDot = document.createElement("div");
  blueDot.style.width = "14px";
  blueDot.style.height = "14px";
  blueDot.style.borderRadius = "50%";
  blueDot.style.background = "#2196f3";
  blueDot.style.flexShrink = "0";
  blueDot.style.cursor = "pointer";

  // 🔴 Red button (logout)
  const redDot = document.createElement("div");
  redDot.style.width = "14px";
  redDot.style.height = "14px";
  redDot.style.borderRadius = "50%";
  redDot.style.background = "#f44336";
  redDot.style.flexShrink = "0";
  redDot.style.cursor = "pointer";
  redDot.title = "Logout";
  redDot.style.display = "none";

  // 👤 Avatar
  const avatar = document.createElement("img");
  avatar.src = avatarURL;
  avatar.alt = "avatar";
  avatar.style.width = "28px";
  avatar.style.height = "28px";
  avatar.style.borderRadius = "50%";
  avatar.style.objectFit = "cover";
  avatar.style.border = "1px solid #888";
  avatar.ondblclick = () => {
    box.style.left = "20px";
    box.style.top = "calc(100% - 80px)";
    localStorage.removeItem("smartStatusX");
    localStorage.removeItem("smartStatusY");
  };

  // Logged text and links
  const infoText = document.createElement("span");
  infoText.innerHTML = `Logged in as: ${user}
    <a href="#" id="infoLink" style="color:#0af; margin-left:6px;">[Info]</a>
    <a href="#" id="logoutLink" style="color:#f55;">[Logout]</a>`;
  infoText.style.whiteSpace = "nowrap";

  box.appendChild(avatar); // 👤 on the left
  box.appendChild(infoText); // text and links
  box.appendChild(blueDot); // 🔵 at the end
  box.appendChild(redDot); // 🔴 after collapse

  document.body.appendChild(box);

  // Animate in
  requestAnimationFrame(() => {
    box.style.left = "20px";
    box.style.opacity = "1";
  });

  // State
  let expanded = true;

  function collapse() {
    expanded = false;
    infoText.style.display = "none";
    redDot.style.display = "inline-block";
    box.style.padding = "6px";
    avatar.style.display = "inline-block"; // 👤 keep avatar visible
  }

  function expand() {
    expanded = true;
    infoText.style.display = "inline";
    redDot.style.display = "none";
    box.style.padding = "6px 12px";
    avatar.style.display = "inline-block";
    box.style.left = localStorage.getItem("smartStatusX") || "20px";
  }

  // Toggle
  blueDot.onclick = () => (expanded ? collapse() : expand());

  redDot.onclick = () => {
    if (confirm("Log out?")) {
      alert("Logging out...");
      localStorage.removeItem("logged");
    }
  };

  infoText.querySelector("#infoLink").addEventListener("click", (e) => {
    e.preventDefault();
    //alert("User info panel goes here");
    showUserInfoPanel();
  });

  infoText.querySelector("#logoutLink").addEventListener("click", (e) => {
    e.preventDefault();
    if (confirm("Log out?")) {
      //alert("Logging out...");
      logout();
      localStorage.removeItem("logged");
    }
  });

  // Drag support
  let isDragging = false,
    offsetX = 0,
    offsetY = 0;

  box.addEventListener("mousedown", (e) => {
    if (e.target.tagName === "A") return;
    isDragging = true;
    offsetX = e.clientX - box.getBoundingClientRect().left;
    offsetY = e.clientY - box.getBoundingClientRect().top;
    box.style.transition = "none";
    document.addEventListener("mousemove", onDrag);
    document.addEventListener("mouseup", onRelease);
  });
  avatar.addEventListener("mousedown", (e) => {
    if (e.target.tagName === "A") return;
    isDragging = true;
    offsetX = e.clientX - box.getBoundingClientRect().left;
    offsetY = e.clientY - box.getBoundingClientRect().top;
    box.style.transition = "none";
    document.addEventListener("mousemove", onDrag);
    document.addEventListener("mouseup", onRelease);
  });
  function onDrag(e) {
    if (!isDragging) return;
    box.style.left = e.clientX - offsetX + "px";
    box.style.top = e.clientY - offsetY + "px";
    box.style.transform = "translateX(0)";
  }

  function onRelease() {
    isDragging = false;
    box.style.transition = "all 0.3s ease";
    localStorage.setItem("smartStatusX", box.style.left);
    localStorage.setItem("smartStatusY", box.style.top);
    document.removeEventListener("mousemove", onDrag);
    document.removeEventListener("mouseup", onRelease);
  }
}
const user = localStorage.getItem("user");
const userid = localStorage.getItem("userid");
const flag = localStorage.getItem("flag");
const level = localStorage.getItem("level");
const img = localStorage.getItem("img");
const user_startDateTime = localStorage.getItem("user_startDateTime");
const user_startTimestamp = localStorage.getItem("user_startTimestamp");
const user_imgr =
  localStorage.getItem("img") || "https://via.placeholder.com/80";
user_img = atob(user_imgr) || "https://i.pravatar.cc/40?u=yanyong";
showSmartUserStatus(user, user_img);
