function makeCountdown(targetId) {
  const target = document.getElementById(targetId);
  isplay: none;"></div>
    </div>
  `;

  const countdown = target.querySelector('#countdown');
  const expiredMsg = target.querySelector('#expiredMsg');
  const expireDate = new Date("2025-12-31T23:59:59");

  function padZero(num) {
    return num < 10 ? `0${num}` : num;
  }

  function updateCountdown() {
    const now = new Date();
    const diff = expireDate - now;

    if (diff <= 0) {
      countdown.textContent = "Countdown: EXPIRED";
      expiredMsg.style.display = "block";
    } else {
      const daysLeft = Math.floor(diff / (1000 * 60 * 60 * 24));
      const hoursLeft = Math.floor((diff / (1000 * 60 * 60)) % 24);
      const minsLeft = Math.floor((diff / (1000 * 60)) % 60);
      const secsLeft = Math.floor((diff / 1000) % 60);
      countdown.textContent = `Countdown: ${daysLeft}d ${padZero(hoursLeft)}h ${padZero(minsLeft)}m ${padZero(secsLeft)}s`;
      expiredMsg.style.display = "none";
    }

    requestAnimationFrame(updateCountdown);
  }

  updateCountdown();
}

function addCountdownStyle() {
  const style = document.createElement('style');
  style.textContent = `
    .clock-container {
      display: flex;
      flex-direction: column;
      align-items: center;
      font-family: sans-serif;
    }

    .countdown {
      margin-top: 6px;
      font-size: 14px;
      color: #666;
    }

    .expired {
      color: red;
      font-weight: bold;
      margin-top: 6px;
    }
  `;
  document.head.appendChild(style);
}

addCountdownStyle();