function makeCountdown(targetId) {
  const target = document.getElementById(targetId);
  if (!target) return;

  target.innerHTML = `
    <div class="clock-container">
      <div class="countdown" id="countdown">Countdown: 00:00:00</div>
      <div class="expired" id="expiredMsg" style="display: none;">EXPIRED!</div>
    </div>
  `;

  const countdown = target.querySelector('#countdown');
  const expiredMsg = target.querySelector('#expiredMsg');
  const expireDate = new Date("2025-12-31T23:59:59");

  function padZero(num) {
    return num < 10 ? `0${num}` : num;
  }

  function updateCountdown() {
    const now = new Date();
    const diff = expireDate - now;

    if (diff <= 0) {
      countdown.textContent = "Countdown: EXPIRED";
      expiredMsg.style.display = "block";
    } else {
      const daysLeft = Math.floor(diff / (1000 * 60 * 60 * 24));
      const hoursLeft = Math.floor((diff / (1000 * 60 * 60)) % 24);
      const minsLeft = Math.floor((diff / (1000 * 60)) % 60);
      const secsLeft = Math.floor((diff / 1000) % 60);
      countdown.textContent = `Countdown: ${daysLeft}d ${padZero(hoursLeft)}h ${padZero(minsLeft)}m ${padZero(secsLeft)}s`;
      expiredMsg.style.display = "none";
    }

    requestAnimationFrame(updateCountdown);
  }

  updateCountdown();
}

function addCountdownStyle() {
  const style = document.createElement('style');
  style.textContent = `
    .itemBoxX {
      margin-top: 1px;
      box-sizing: border-box;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 33.33%;
      width: 100%;
    }

    .clock-container {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      font-family: sans-serif;
      height: 100%;
      width: 100%;
      padding: 5px;
      box-sizing: border-box;
    }

    .countdown {
      font-size: 12px; /* Reduced from 14px to fit better */
      color: #666;
    }

    .expired {
      color: red;
      font-weight: bold;
      font-size: 12px; /* Match countdown size */
    }
  `;
  document.head.appendChild(style);
}

addCountdownStyle();