function makeDigitalClock(targetId) {
  const target = document.getElementById(targetId);
  if (!target) return;

  target.innerHTML = `
    <div class="clock-container">
      <div class="info-panel">
        <div class="day-night-container">
          <div class="info date" id="dateInfo"></div>
          <div class="info day" id="dayInfo"></div>             
          <div class="day-night day-indicator" id="dayNight"></div>      
        </div>
        <div class="day-night-container">
          <div class="digital-clock" id="digitalClock">00:00:00</div>
          <div class="day-night-indicator" id="dayNightIndicator"></div>
        </div>
      </div>
    </div>
  `;

  const digitalClock = target.querySelector('#digitalClock');
  const dateInfo = target.querySelector('#dateInfo');
  const dayInfo = target.querySelector('#dayInfo');
  const dayNight = target.querySelector('#dayNight');
  const dayNightIndicator = target.querySelector('#dayNightIndicator');

  function padZero(num) {
    return num < 10 ? `0${num}` : num;
  }

  function updateDigitalClock() {
    const now = new Date();
    digitalClock.textContent = `${padZero(now.getHours())}:${padZero(now.getMinutes())}:${padZero(now.getSeconds())}`;

    const days = ["Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday"];
    const months = ["Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec"];
    dateInfo.textContent = `Date: ${now.getDate()} ${months[now.getMonth()]} ${now.getFullYear()}`;
    dayInfo.textContent = `${days[now.getDay()]}`;
    dayNight.textContent = now.getHours() >= 6 && now.getHours() < 18 ? "Day" : "Night";
    dayNightIndicator.className = now.getHours() >= 6 && now.getHours() < 18
      ? "day-night-indicator day"
      : "day-night-indicator night";

    requestAnimationFrame(updateDigitalClock);
  }

  updateDigitalClock();
}

function addDigitalClockStyle() {
  const style = document.createElement('style');
  style.textContent = `
    .itemBoxX {
      margin-top: 1px;
      box-sizing: border-box;
      display: flex;
      justify-content: center;
      align-items: center;
      height: 33.33%;
      width: 100%;
    }

    .clock-container {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      font-family: sans-serif;
      height: 100%;
      width: 100%;
      padding: 5px;
      box-sizing: border-box;
    }

    .info-panel {
      display: flex;
      flex-direction: column;
      align-items: center;
      width: 100%;
      font-size: 12px; /* Reduced to fit better */
    }

    .day-night-container {
      display: flex;
      align-items: center;
      justify-content: center;
      gap: 10px;
      width: 100%;
    }

    .digital-clock {
      font-size: 16px; /* Reduced from 20px to fit better */
      font-weight: bold;
    }

    .day-night-indicator {
      width: 12px;
      height: 12px;
      border-radius: 50%;
      animation: pulse 2s infinite;
    }

    .day-night-indicator.day { background: #f4d99f; box-shadow: 0 0 6px #f15e03; }
    .day-night-indicator.night { background: #2196F3; box-shadow: 0 0 6px #2196F3; }

    @keyframes pulse {
      0% { transform: scale(1); opacity: 1; }
      50% { transform: scale(1.3); opacity: 0.7; }
      100% { transform: scale(1); opacity: 1; }
    }
  `;
  document.head.appendChild(style);
}

addDigitalClockStyle();