/* ========= Tiny Draggable Pill Listener ========= */
(() => {
  const ID = 'tinyListener';
  if (document.getElementById(ID)) return;   // singleton

  /* ---- 1.  pill element ---- */
  const pill = document.createElement('div');
  pill.id = ID;
  pill.innerHTML = `
    <div class="avatar">🧑‍💻</div>
    <div class="dot" data-action="menu"  title="Toggle menu">●</div>
    <div class="dot" data-action="close" title="Close pill">●</div>
  `;
  document.body.appendChild(pill);

  /* ---- 2.  styles ---- */
  addStyle(`
    #tinyListener{
      position:fixed; left:8px; bottom:8px;
      display:flex; align-items:center; gap:6px;
      padding:4px 8px 4px 4px;
      background:rgba(30,30,30,.75);
      color:#fff; border-radius:20px;
      font-size:14px; cursor:grab; user-select:none;
      z-index:9999; transition:transform .2s;
    }
    #tinyListener:active{cursor:grabbing;}
    #tinyListener .avatar{width:24px;height:24px;border-radius:50%;display:flex;align-items:center;justify-content:center;background:#444;}
    #tinyListener .dot{font-size:18px; cursor:pointer;}
    #tinyListener .dot:hover{transform:scale(1.25);}
  `);

  /* ---- 3.  drag logic (re-use micro2 helpers) ---- */
  let dragOffsetX = 0, dragOffsetY = 0, isDragging = false;

  pill.addEventListener('mousedown', start);
  pill.addEventListener('touchstart', start, {passive:false});

  function start(e){
    if (e.target.classList.contains('dot')) return; // let dots bubble
    e.preventDefault();
    const r = pill.getBoundingClientRect();
    const cX = e.touches ? e.touches[0].clientX : e.clientX;
    const cY = e.touches ? e.touches[0].clientY : e.clientY;
    dragOffsetX = cX - r.left;
    dragOffsetY = cY - r.top;
    isDragging = true;

    document.addEventListener('mousemove', move);
    document.addEventListener('mouseup', stop);
    document.addEventListener('touchmove', move, {passive:false});
    document.addEventListener('touchend', stop);
  }
  function move(e){
    if (!isDragging) return;
    const cX = e.touches ? e.touches[0].clientX : e.clientX;
    const cY = e.touches ? e.touches[0].clientY : e.clientY;
    pill.style.left = (cX - dragOffsetX) + 'px';
    pill.style.bottom = 'auto';
    pill.style.top  = (cY - dragOffsetY) + 'px';
  }
  function stop(){
    isDragging = false;
    document.removeEventListener('mousemove', move);
    document.removeEventListener('mouseup', stop);
    document.removeEventListener('touchmove', move);
    document.removeEventListener('touchend', stop);
  }

  /* ---- 4.  dot click handlers ---- */
  pill.addEventListener('click', e => {
    const act = e.target.dataset.action;
    if (act === 'menu') toggleLeftMenu?.();   // uses earlier function
    if (act === 'close') pill.remove();
  });
})();