async function loadAndUpdateGS(id) {
   idx = "myPanel";
  const existing = document.getElementById(id);
// Check and remove existing panel if it exists
  const existingPanel = document.getElementById(idx);
  if (existingPanel) {
    try {
      // Try to use panel system's close method if available
      if (existingPanel.close) {
        existingPanel.close();
      } else {
        // Fallback removal
        existingPanel.remove();
      }
    } catch (e) {
      console.error("Error removing existing panel:", e);
    }
  }

  // Check and remove existing progress circle if it exists
  const existingLeftOne = document.getElementById("leftone");
  if (existingLeftOne) {
    try {
      existingLeftOne.remove();
    } catch (e) {
      console.error("Error removing existing leftone:", e);
    }
  }

  // Check and remove right content if it exists
  const existingRightOne = document.getElementById("rightone");
  if (existingRightOne) {
    try {
      existingRightOne.remove();
    } catch (e) {
      console.error("Error removing existing rightone:", e);
    }
  }
  aa = 0;
  bb = 0;
  lbb = 0;

  try {
    const data = await loadDataOnly(id);
    console.log("✔️ Raw data from loadDataOnly():", data);

    bucket = safeParseJSON(data.bucket) || {};
    cup = safeParseJSON(data.cup) || {};
    board = safeParseJSON(data.board) || {};

    console.log("✔️ Parsed bucket:", bucket);
    console.log("✔️ Parsed cup:", cup);
    console.log("✔️ Parsed board:", board);

    const containers = [
      { data: bucket, name: "Bucket" },
      { data: cup, name: "Cup" },
      { data: board, name: "Board" },
    ].filter(c => c.data && Object.keys(c.data).length);

    if (containers.length === 0) {
      console.warn("⚠️ No valid containers with data.");
      return;
    }

    const summaryData = [];  // ✅ define inside try block

    let totalAnsweredRequired = 0;
    let totalRequired = 0;

    console.log("=== Summary ===");

    containers.forEach(container => {
      const summaryResult = QSummary(container.data);
      if (!summaryResult?.summary?.totals) {
        console.warn(`⚠️ QSummary failed for ${container.name}`);
        return;
      }

      const s = summaryResult.summary.totals;

      const requiredPercent = s.requiredFields > 0
        ? Math.round((s.answeredRequiredFields / s.requiredFields) * 100)
        : 0;

      summaryData.push({
        title: `📦 ${container.name}`,
        required: `${s.answeredRequiredFields}/${s.requiredFields}`,
        totalFields: `${s.answeredFields}/${s.allFields}`,
        files: s.totalFiles || 0,
        progress: requiredPercent,
      });

      totalAnsweredRequired += s.answeredRequiredFields;
      totalRequired += s.requiredFields;

      console.log(`📦 ${container.name}`);
      console.log(`  - Required: ${s.answeredRequiredFields}/${s.requiredFields}`);
      console.log(`  - Total Fields: ${s.answeredFields}/${s.allFields}`);
      console.log(`  - Files: ${s.totalFiles || 0}`);
      console.log(`  - Progress: ${requiredPercent}%`);
    });

    // Render panel
    bb = `Total Fields: ${aa}/${bb}`;
    createPanel(idx, "CC", "ctc", 620, window.innerHeight-10, {
      title: "myPanel 🦘",
      noFooter: true,
      noDrag: false,
      forceReload:true,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
       <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 2px;">
    <p><div id="leftone">${bb}</div></p>
    
  </div>
  <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px;">
    <div id="rightone"></div>
    
  </div>
      </div>`
    });

    // ⭕ Initialize circular progress bar
    
    const update = makeCircleProgress("leftone");
    update(totalAnsweredRequired, totalRequired);

    // ✅ Now render the summary
    renderSummary(summaryData, "rightone");
    document.getElementById("leftone").insertAdjacentHTML("beforeend", `
<div class="itemBoxX" style="margin-top: 1px;">
      <div id="analogClock"></div>
    </div>
    <div class="itemBoxX" style="margin-top: 1px;">
      <div id="digitalClock"></div>
    </div>
    <div class="itemBoxX" style="margin-top: 1px;">
      <div id="countdownClock"></div>
    </div>
   
`);

makeAnalogClock("analogClock");
makeDigitalClock("digitalClock");
makeCountdown("countdownClock");
  } catch (e) {
    console.error("❌ Error loading and summarizing:", e);
  }
}

async function loadAndUpdateSummaries(id) {
        try {
            // Show loading indicator
            toast(
                "⏳ Loading summaries...",
                { pos: "BR", slide: "ttb" },
                { background: "blue" },
            );

            const data = await loadDataOnly(id);
            if (!data) {
                toast(
                    "⚠️ No data received",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Parse and store into memory
            bucket = safeParseJSON(data.bucket) || {};
            cup = safeParseJSON(data.cup) || {};
            board = safeParseJSON(data.board) || {};
            // Normalize grouping data (works with both structures)
            const normalizedGrouping = normalizeGroupingData(bucket);
            if (normalizedGrouping) {
                // For backward compatibility, ensure bucket has grouping in expected format
                if (!bucket.grouping && !bucket.data_type) {
                    bucket.grouping = normalizedGrouping;
                }
            }
            // Verify data was loaded
            if (
                Object.keys(bucket).length === 0 &&
                Object.keys(cup).length === 0 &&
                Object.keys(board).length === 0
            ) {
                toast(
                    "⚠️ Empty data loaded",
                    { pos: "TR", slide: "ttb" },
                    { background: "orange" },
                );
                return;
            }

            // Check for cup data and warn if missing
            if (!cup || Object.keys(cup).length === 0) {
                toast(
                    "⚠️ No Cup data found",
                    { pos: "TR", slide: "rtl" },
                    { background: "orange" },
                );
            }

            // Update summary UIs
            updateGrandSummary("summan", true, true);

            // Also update other summary panels if they exist
            if (document.getElementById("requirementProgress")) {
                const totals = QSummary(bucket).summary.totals;
                updateRequirementProgress(
                    totals.answeredRequiredFields,
                    totals.requiredFields,
                );
            }

            if (document.getElementById("requirementChecklist")) {
                updateRequirementChecklist([
                    { data: bucket, name: "Bucket" },
                    { data: cup, name: "Cup" },
                ]);
            }

            toast(
                "✅ Summaries updated",
                { pos: "BR", slide: "RTL" },
                { background: "green" },
            );
        } catch (e) {
            console.error("❌ Failed to load summaries:", e);
            toast(
                "❌ Failed to load summaries",
                { pos: "TR", slide: "ttb" },
                { background: "red" },
            );
        }
    }