function toggleLogonoff(divId) {
  const el = document.getElementById(divId);
  if (!el) return;

  // Initial check or toggle
  let isLogged = localStorage.getItem("logged") === "true";

  function updateUI() {
    if (isLogged) {
      el.textContent = "Logged";
      el.style.color = "green";
    } else {
      el.textContent = "Log On";
      el.style.color = "red";
    }
    el.style.cursor = "pointer";
    el.style.fontWeight = "bold";
    el.style.userSelect = "none";
    el.title = "Click to toggle login state";
  }

  // Click handler
  el.onclick = () => {
    if (isLogged) {
      if (confirm("Log out?")) {
        isLogged = false;
        localStorage.removeItem("logged");
        if (typeof logout === "function") logout();
        updateUI();
      }
    } else {
      isLogged = true;
      localStorage.setItem("logged", "true");
      updateUI();
    }
  };

  updateUI(); // Set initial state
}
