(function () {
  // Inject styles
  const css = `
    body {
      margin: 0;
      font-family: sans-serif;
    }
    #smartBar {
      position: fixed;
      top: 0;
      left: 0;
      width: 220px;
      height: 100vh;
      background: #f0f0f0;
      box-shadow: 2px 0 5px rgba(0,0,0,0.2);
      padding: 10px;
      box-sizing: border-box;
      display: flex;
      flex-direction: column;
      gap: 10px;
      z-index: 9999;
    }
    .menuGroup { margin-bottom: 10px; }
    .groupTitle {
      font-weight: bold;
      font-size: 14px;
      margin-bottom: 5px;
      color: #333;
    }
    .menuButton {
      background: white;
      border-radius: 6px;
      padding: 8px 12px;
      margin-bottom: 4px;
      font-size: 13px;
      cursor: pointer;
      position: relative;
      display: flex;
      flex-direction: column;
    }
    .menuTop {
      display: flex;
      gap: 8px;
      align-items: center;
    }
    .icon { font-size: 18px; }
    .labelText { flex-grow: 1; font-weight: 500; }
    .badge {
      position: absolute;
      top: 6px;
      right: 10px;
      background: red;
      color: white;
      font-size: 11px;
      border-radius: 12px;
      padding: 1px 4px;
      display: none;
    }
    .statusLabel {
      font-size: 11px;
      margin-left: 26px;
    }
    .statusLabel[data-status="done"]    { color: green; }
    .statusLabel[data-status="pending"] { color: orange; }
    .statusLabel[data-status="start"]   { color: gray; }
    .statusLabel[data-status="in progress"] { color: dodgerblue; }
    .progressBar {
      height: 6px;
      background: #ddd;
      border-radius: 3px;
      overflow: hidden;
      margin-left: 26px;
      margin-right: 8px;
    }
    .progressInner {
      height: 100%;
      background: #007bff;
      width: 0%;
      transition: width 0.3s;
    }
    .checklistItem {
      display: flex;
      align-items: center;
      gap: 10px;
      margin-left: 26px;
      font-size: 13px;
      color: #333;
    }
    .lang-toggle {
      display: flex;
      align-items: center;
      gap: 10px;
      font-size: 13px;
      padding: 4px 6px;
    }
    .lang-switch {
      position: relative;
      width: 40px;
      height: 20px;
    }
    .lang-switch input {
      opacity: 0;
      width: 0;
      height: 0;
    }
    .lang-slider {
      position: absolute;
      cursor: pointer;
      top: 0; left: 0; right: 0; bottom: 0;
      background-color: #bbb;
      transition: 0.3s;
      border-radius: 20px;
    }
    .lang-slider:before {
      position: absolute;
      content: "";
      height: 14px;
      width: 14px;
      left: 3px;
      bottom: 3px;
      background-color: white;
      transition: 0.3s;
      border-radius: 50%;
    }
    .lang-switch input:checked + .lang-slider {
      background-color: #6da7ff;
    }
    .lang-switch input:checked + .lang-slider:before {
      transform: translateX(20px);
    }
    .lang-label { font-size: 12px; color: #444; user-select: none; }
    .bottomBar {
      margin-top: auto;
      display: flex;
      flex-direction: column;
      gap: 4px;
    }
    .statusDisplay {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 12px;
      background: #fff;
      padding: 5px;
      border-radius: 5px;
      color: #333;
    }
    .statusDot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
    }
    .greenDot { background: green; }
    .redDot { background: red; }
    .bottomRow {
      display: flex;
      justify-content: space-between;
      align-items: center;
    }
    #avatar {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: url('https://i.pravatar.cc/24') no-repeat center;
      background-size: cover;
    }
    #loginToggle {
      font-size: 12px;
      cursor: pointer;
      color: #007BFF;
    }
    button {
      font-size: 13px;
      padding: 4px 8px;
      cursor: pointer;
    }
  `;
  const style = document.createElement('style');
  style.textContent = css;
  document.head.appendChild(style);

  // Menu Data
  const menuData = [ {
    group: "Main",
    items: [
      {
        item: "A1",
        icon: "⬇️",
        text: "KTB2025",
        badgeCount: 1,
        progress: 45,
        status: "in progress",
        onclick: () => loadAndUpdateSummaries(userid)
      }
    ]
  },
  {
    group: "Tracking",
    items: [
      {
        item: "assessment",
        icon: "📦",
        text: "Assessment",
        status: "pending",
        progress: 10,
        onclick: () =>{PanelTR();genpaN(userid)}},
      {
        item: "Profile",
        icon: "💳",
        text: "Profile",
        status: "done",
        progress: 100,
        onclick: () => {PanelTR();profilepaN(userid)}
      }
    ]
  },
  {
        group: "Actions",
        items: [
          {
            item: "save",
            icon: "💾",
            text: "Save",
            badgeCount: 0,
            onclick: () => saveToServerM(userid)
          }
        ]
      }, {
        group: "User Actions",
        items: [
          {
            item: "profilez",
            icon: "👤",
            text: "User",
            badgeCount: 2,
            onclick: () => showUserUpdatePanel()
          },
          {
            item: "settings",
            icon: "⚙️",
            text: "Jumper",
            badgeCount: 1,
            onclick: () => togglePanelTR()
          }
        ]
      }
];

  // Create structure
  const smartBar = document.createElement('div');
  smartBar.id = 'smartBara';
  smartBar.innerHTML = `
    <div id="smartBarIn"></div>
    <div class="bottomBar">
    <!--  
    <div style="display: flex; gap: 6px; flex-wrap: wrap;">
  <button onclick="runRandomUpdates()">🔁</button>
  <button onclick="clearAllBadges()">🧹</button>
  <button onclick="showSmartBar()">👁️</button>
  <button onclick="hideSmartBar()">🙈</button>
  <button onclick="toggleSmartBar()"></button>
</div>
-->
      <div class="menuItem lang-toggle" id="languageToggleRow">
        <div class="lang-label">Language</div>
        <label class="lang-switch">
          <input type="checkbox" id="langToggle">
          <span class="lang-slider"></span>
        </label>
        <div class="lang-label" id="langText">EN</div>
      </div>
      <div class="statusDisplay">
        <div class="statusDot greenDot"></div>
        <div>Status: Ready</div>
        <div class="statusDot redDot"></div>
      </div>
      <div class="bottomRow">
        <div id="avatar"></div>
        <div id="loginToggle">Log On</div>
      </div>
    </div>
  `;
   createPanel("test2", "TL", "ctc", 150, window.innerHeight-10, { 
noFooter: true,
            bodyCloseButton: false,            
            
  bodyContent: `<div id="xxx"></div>`,
});
const targetBody = document.getElementById("xxx");
 targetBody.appendChild(smartBar);
  //document.body.appendChild(smartBar);

  // Render Menu
  function renderMenu() {
    const bar = document.getElementById('smartBarIn');
    bar.innerHTML = '';
    menuData.forEach(group => {
      const groupDiv = document.createElement('div');
      groupDiv.className = 'menuGroup';
      const title = document.createElement('div');
      title.className = 'groupTitle';
      title.textContent = group.group;
      groupDiv.appendChild(title);
      group.items.forEach(item => {
        const btn = document.createElement('div');
        btn.className = 'menuButton';
        btn.id = item.item;
        const topRow = document.createElement('div');
        topRow.className = 'menuTop';
        topRow.innerHTML = `
          <span class="icon">${item.icon || ''}</span>
          <span class="labelText">${item.text || item.item}</span>
          <span class="badge" id="badge_${item.item}">${item.badgeCount || ''}</span>
        `;
        btn.appendChild(topRow);
        if (item.status) {
          const status = document.createElement('div');
          status.className = 'statusLabel';
          status.id = `status_${item.item}`;
          status.dataset.status = item.status.toLowerCase();
          status.textContent = item.status;
          btn.appendChild(status);
        }
        if (typeof item.progress === 'number') {
          const progressBar = document.createElement('div');
          progressBar.className = 'progressBar';
          const inner = document.createElement('div');
          inner.className = 'progressInner';
          inner.style.width = item.progress + '%';
          inner.id = `progress_${item.item}`;
          progressBar.appendChild(inner);
          btn.appendChild(progressBar);
        }
        if (item.checklist) {
          const checkDiv = document.createElement('div');
          checkDiv.className = 'checklistItem';
          const checkbox = document.createElement('input');
          checkbox.type = 'checkbox';
          checkbox.checked = !!item.checked;
          checkbox.id = `check_${item.item}`;
          checkbox.addEventListener('change', () => {
            item.checked = checkbox.checked;
            alert(`Checklist ${item.item}: ${checkbox.checked ? 'Done' : 'Not Done'}`);
          });
          const label = document.createElement('label');
          label.textContent = 'Complete?';
          label.htmlFor = checkbox.id;
          checkDiv.appendChild(checkbox);
          checkDiv.appendChild(label);
          btn.appendChild(checkDiv);
        }
        if (typeof item.onclick === 'function') {
          btn.addEventListener('click', item.onclick);
        }
        groupDiv.appendChild(btn);
        updateBadge(item.item, item.badgeCount || 0);
      });
      bar.appendChild(groupDiv);
    });
  }

  function updateBadge(id, count) {
    const badge = document.getElementById(`badge_${id}`);
    if (!badge) return;
    badge.textContent = count;
    badge.style.display = count > 0 ? 'inline-block' : 'none';
  }

  function updateProgress(id, percent) {
    const bar = document.getElementById(`progress_${id}`);
    if (bar) bar.style.width = `${percent}%`;
  }

  function updateStatus(id, status) {
    const div = document.getElementById(`status_${id}`);
    if (div) {
      div.textContent = status;
      div.dataset.status = status.toLowerCase();
    }
  }

  function updateChecklist(id, checked) {
    const box = document.getElementById(`check_${id}`);
    if (box) box.checked = checked;
  }

  window.runRandomUpdates = function () {
    menuData.forEach(group => {
      group.items.forEach(item => {
        updateBadge(item.item, Math.floor(Math.random() * 5));
        updateProgress(item.item, Math.floor(Math.random() * 100));
        const statuses = ['done', 'in progress', 'start', 'pending'];
        updateStatus(item.item, statuses[Math.floor(Math.random() * statuses.length)]);
        updateChecklist(item.item, Math.random() > 0.5);
      });
    });
  };
  // --- New Helper Functions ---

  window.clearAllBadges = function () {
    document.querySelectorAll('#smartBar .badge').forEach(badge => {
      badge.textContent = '';
      badge.style.display = 'none';
    });
  };

  window.showSmartBar = function () {
    const sb = document.getElementById('smartBar');
    if (sb) sb.style.display = 'flex';
  };

  window.hideSmartBar = function () {
    const sb = document.getElementById('smartBar');
    if (sb) sb.style.display = 'none';
  };

  window.toggleSmartBar = function () {
    const sb = document.getElementById('smartBar');
    if (sb) {
      sb.style.display = (sb.style.display === 'none' ? 'flex' : 'none');
    }
  };
/*
clearAllBadges();  // Clears all badges
  hideSmartBar();    // Hides the sidebar
  showSmartBar();    // Shows the sidebar
  toggleSmartBar();  // Toggles visibility
*/
function PanelTR() {
  const id = "myPanelTR";
  const existing = document.getElementById(id);
  
    createPanel(id, "TR", "rtl", 520, window.innerHeight, {
      title: "JumperHelperSumman",
      noFooter: true,
      noDrag :true,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
      <p><div id="jumperhelper"></div></p>
      <p>Jumper Helper Jumpt to unanswered</p>
    </div>
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
     <div id="summan"></div>
    </div>
  </div>
  
  </div>`,
    });
  
}
function togglePanelTR() {
  const id = "myPanelTR";
  const existing = document.getElementById(id);
  if (existing) {
    closePanel(id);
  } else {
    createPanel(id, "TR", "rtl", 520, window.innerHeight, {
      title: "JumperHelperSumman",
      noFooter: true,
      noDrag :true,
      bodyContent: `<div style="display: flex; height: 100%; overflow: hidden;">
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
      <p><div id="jumperhelper"></div></p>
      <p>Jumper Helper Jumpt to unanswered</p>
    </div>
    <div style="flex: 1; box-sizing: border-box; overflow: auto; padding: 10px; ">
     <div id="summan"></div>
    </div>
  </div>
  
  </div>`,
    });
  }
}
  function initLangToggle() {
    const toggle = document.getElementById('langToggle');
    const langText = document.getElementById('langText');
    const lang = localStorage.getItem('language') || 'EN';
    toggle.checked = lang === 'TH';
    langText.textContent = lang;
    toggle.addEventListener('change', () => {
      const newLang = toggle.checked ? 'TH' : 'EN';
      localStorage.setItem('language', newLang);
      langText.textContent = newLang;
    });
  }

  document.getElementById('loginToggle').addEventListener('click', () => {
    const el = document.getElementById('loginToggle');
    el.textContent = el.textContent === 'Log On' ? 'Log Off' : 'Log On';
  });

  initLangToggle();
  renderMenu();
})();
