(function () {
  // Inject styles
  const css = `
    .menuGroup { margin-bottom: 6px; } /* Reduced from 10px */
    .groupTitle {
//    font-weight: bold;
    font-size: 13px; /* Reduced from 14px */
    margin-bottom: 3px; /* Reduced from 5px */
    color:rgba(20,20,20,.3);
    padding-left: 4px;
  }
    .menuButton {
    background: rgba(255,255,255,.8);
    border-radius: 4px; /* Reduced from 6px */
    padding: 6px 8px; /* Reduced from 8px 12px */
    margin-bottom: 2px; /* Reduced from 4px */
    font-size: 12px; /* Reduced from 13px */
    cursor: pointer;
    position: relative;
    display: flex;
    flex-direction: column;
  }

     .menuTop {
    display: flex;
    gap: 6px; /* Reduced from 8px */
    align-items: center;
  }

    .statusLabel {
    font-size: 10px; /* Reduced from 11px */
    margin-left: 22px; /* Reduced from 26px */
    margin-bottom: 2px; /* Reduced from 4px */
  }
    .statusLabel[data-status="done"]    { color: green; }
    .statusLabel[data-status="pending"] { color: orange; }
    .statusLabel[data-status="start"]   { color: gray; }
    .statusLabel[data-status="in progress"] { color: dodgerblue; }
    .progressBar {
     height: 4px; /* Reduced from 6px */
    margin-bottom: 2px; /* Reduced from 4px */
      background: #ddd;
      border-radius: 3px;
      overflow: hidden;
      margin-left: 0px;
      margin-right: 0px;

    }
    .progressInner {
      height: 100%;
      background: #007bff;
      width: 0%;
      transition: width 0.3s;
    }


    .bottomBar {
      margin-top: 20px;
      display: flex;
      flex-direction: column;
       margin-top: 12px; /* Reduced from 20px */
    gap: 4px; /* Reduced from 8px */
    }
    .statusDisplay {
      display: flex;
      justify-content: space-between;
      align-items: center;
      font-size: 12px;
      background: #fff;
      padding: 5px 8px;
      border-radius: 5px;
      color: #333;
      gap: 8px;
    }
    .statusDot {
      width: 10px;
      height: 10px;
      border-radius: 50%;
    }
    .greenDot { background: green; }
    .redDot { background: red; }
    .bottomRow {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 5px 8px;
      background: #fff;
      border-radius: 5px;
    }
    #avatar {
      width: 24px;
      height: 24px;
      border-radius: 50%;
      background: url('https://i.pravatar.cc/24') no-repeat center;
      background-size: cover;
    }
    #loginToggle {
      font-size: 12px;
      cursor: pointer;
      color: #007BFF;
    }
    .menufooter {
      display: flex;
      flex-direction: column;
      gap: 8px;
    }
    .badge {
    position: absolute;

  text-align: center;
  color: white;
  border-radius: 7px;
    right: 1px; /* Reduced from 4px */
    top: 1px; /* Reduced from 4px */
    min-width: 12px; /* Reduced from 14px */
    height: 12px; /* Reduced from 14px */
    padding: 0 2px; /* Reduced from 3px */
    font-size: 9px; /* Reduced from 9px */
    line-height: 12px; /* Adjusted */
    border-radius: 6px; /* Reduced from 7px */
  }
    .badge-text {
    top: 1px; /* Reduced from 4px */
      white-space: nowrap;
      overflow: hidden;
      text-overflow: ellipsis;
      max-width: 50px;
       position: relative;
  top: 1px; /* Pull text up slightly more than numbers */
    }
    /* Language switcher styles */
     .lang-switcher-container {
     padding: 2px 4px; /* Reduced from 4px 8px */
    height: 24px; /* Reduced from 28px */
    background: rgba(100,100,100,.2);
    border-radius: 5px;
     display: flex;
  align-items: center; /* Vertical center */
  justify-content: flex-end; /* Push to right but keep centered */
  height: 100%;
  padding: 0 4px;

  }
    .lang-switcher-slide {
      font-family: Arial, sans-serif;
      position: relative;
      display: inline-block;
     height:20px;
      background: #f0f0f0;
      border-radius: 20px;
      overflow: visible;
      cursor: pointer;

    }
    .lang-slide-option {
      position: absolute;
      width: 50%;
      height: 100%;
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 2;
      color: #666;
      font-size: 14px; /* Reduced from 12px */
      margin: 0px;
      transition: color 0.3s;
    }
    .lang-slide-option:nth-child(1) { left: 0; }
    .lang-slide-option:nth-child(2) { left: 50%; }
    .lang-switcher-slide:not(.active) .lang-slide-option:nth-child(1),
    .lang-switcher-slide.active .lang-slide-option:nth-child(2) {
      color: white;
    }
    .lang-slide-indicator {
      position: absolute;
      width: 50%;
      height: 100%;
      background: #007bff;
      border-radius: 20px;
      transition: all 0.3s ease;
      left: 0;
      z-index: 1;
    }
    .lang-switcher-slide.active .lang-slide-indicator {
      left: 50%;
      background: #28a745;
    }
      /* Language switcher sizing */
  .lang-switcher-slide {
    width: 80px; /* Reduced from 120px */
    height: 20px; /* Reduced from 40px */
 margin: 0 auto; /* Horizontal center within flex container */
  position: relative;
  top: 0; /* Remove any offset */
  }
  .lang-label {
  font-size:12px;
  margin-left:2px;
  color:rgba(10,10,10,.4);
  }
    .lang-switcher-slide{
        top: -2px;    /* Moves up */

    align-self: flex-end; /* Aligns to end of container */
    //right: -50px;  /* Moves right */
 margin: 0 auto; /* Horizontal center within flex container */
  position: relative;
  top: 0; /* Remove any offset */
    scale:.8;
    }
    .statusDisplay, .bottomRow {
    padding: 3px 8px; /* Reduced from 5px 8px */
    background:rgba(100,100,100,.2);
  }
    .menuButton {
  padding-right: 18px; /* Reduced from 20px */
}
  
  `;
  const style = document.createElement("style");
  style.textContent = css;
  document.head.appendChild(style);

  // Menu Data
  const menuData = [
    {
      group: "Main",
      items: [
        {
          item: "A1",
          icon: "💎",
          text: "KTB2025",
          badge: { value: "NEW", color: "#ff5722" },
          progress: 50,
          status: "Welcome",
          onclick: () => loadAndUpdateSummaries(userid),
        },
      ],
    },
    {
      group: "Tracking",
      items: [
        {
          item: "assessment",
          icon: "📦",
          text: "Assessment",
          badge: { value: "", color: "#ff5722" },

          status: "start",
          progress: 50,
          onclick: () => {
            PanelTR();
            genpaN(userid);
          },
        },
        {
          item: "Profile",
          icon: "💳",
          text: "Profile",
          badge: { value: "", color: "#ff5722" },
          status: "start",
          progress: 10,
          onclick: () => {
            PanelTR();
            profilepaN(userid);
          },
        },
      ],
    },
    {
      group: "Actions",
      items: [
        {
          item: "save",
          icon: "💾",
          text: "Save",
          badge: { value: 0 },
          onclick: () => saveToServerM(userid),
        },
      ],
    },
    {
      group: "User Actions",
      items: [
        {
          item: "profilez",
          icon: "👤",
          text: "User",
          badge: { value: 0, color: "#4caf50" },
          onclick: () => showUserUpdatePanel(),
        },
        {
          item: "mypanel",
          icon: "⚙️",
          text: "my",
          badge: { value: 0, color: "#f44336" },
          onclick: () => {
            loadAndUpdateGS(userid);
            renderCupToDivProfileML(userid);
          },
        }
      ],
    },
  ];

  // Create structure
  const smartBar = document.createElement("div");
  smartBar.id = "smartBara";
  smartBar.style.display = "flex";
  smartBar.style.flexDirection = "column";
  smartBar.style.height = "100%";
  smartBar.innerHTML = `
    <div id="smartBarIn" style="flex-grow: 1;"></div>
    <div class="bottomBar">
      <div class="lang-switcher-container">
         <div class="lang-label" id="langText">Language </div>
        <div class="lang-switcher-slide" id="slideSwitch" onclick="toggleLang()" title="Click to toggle language">
          <div class="lang-slide-option">EN</div>
          <div class="lang-slide-option">TH</div>
          <div class="lang-slide-indicator"></div>
        </div>

      </div>
      <div class="menufooter">
        <div class="statusDisplay">
          <div id="statusGreenDot" class="statusDot greenDot"></div>
          <div id="statusDisplay">Status: </div>
          <div id="statusRedDot" class="statusDot redDot"></div>
        </div>
        <div class="bottomRow">
          <div id="avatar"></div>
          <div id="loginToggle">Log On</div>
        </div>
      </div>
    </div>
  `;

  createPanel("test2", "TL", "ctc", 150, window.innerHeight , {
    title: "📇",
    noFooter: true,
    bodyCloseButton: false,
    bodyContent: `<div id="xxx" style="height:100%;"></div>`,
  });

  const targetBody = document.getElementById("xxx");
  targetBody.appendChild(smartBar);

  // Initialize language switcher
  const savedLang = localStorage.getItem("language") || "en";
  window.lang = savedLang;
  updateSwitch(savedLang);

  function renderMenu(showIcons = true, showBadges = true) {
    const bar = document.getElementById("smartBarIn");
    bar.innerHTML = "";
    menuData.forEach((group) => {
      const groupDiv = document.createElement("div");
      groupDiv.className = "menuGroup";
      const title = document.createElement("div");
      title.className = "groupTitle";
      title.textContent = group.group;
      groupDiv.appendChild(title);
      group.items.forEach((item) => {
        const btn = document.createElement("div");
        btn.className = "menuButton";
        btn.id = item.item;
        const topRow = document.createElement("div");
        topRow.className = "menuTop";

        // Build badge HTML if needed
        let badgeHtml = "";
        if (showBadges && item.badge) {
          const badgeValue = item.badge.value;
          const badgeColor = item.badge.color || "#007bff";
          const displayValue =
            badgeValue !== undefined && badgeValue !== null && badgeValue !== ""
              ? badgeValue
              : "";

          badgeHtml = `
            <span class="badge" id="badge_${item.item}"
                  style="background-color: ${badgeColor}; display: ${displayValue ? "inline-block" : "none"}">
              <span class="badge-text">${displayValue}</span>
            </span>
          `;
        }

        topRow.innerHTML = `
  ${showIcons ? `<span class="icon">${item.icon || ""}</span>` : ""}
  <span class="labelText">${item.text || item.item}</span>
  ${
    showBadges && item.badge
      ? `
    <span class="badge" id="badge_${item.item}"
          style="background-color: ${item.badge.color || "#007bff"};
                 display: ${item.badge.value ? "inline-block" : "none"}">
      ${item.badge.value || ""}
    </span>
  `
      : ""
  }
`;
        btn.appendChild(topRow);

        if (item.status) {
          const status = document.createElement("div");
          status.className = "statusLabel";
          status.id = `status_${item.item}`;
          status.dataset.status = item.status.toLowerCase();
          status.textContent = item.status;
          btn.appendChild(status);
        }

        if (typeof item.progress === "number") {
          const progressBar = document.createElement("div");
          progressBar.className = "progressBar";
          const inner = document.createElement("div");
          inner.className = "progressInner";
          inner.style.width = item.progress + "%";
          inner.id = `progress_${item.item}`;
          progressBar.appendChild(inner);
          btn.appendChild(progressBar);
        }

        if (item.checklist) {
          const checkDiv = document.createElement("div");
          checkDiv.className = "checklistItem";
          const checkbox = document.createElement("input");
          checkbox.type = "checkbox";
          checkbox.checked = !!item.checked;
          checkbox.id = `check_${item.item}`;
          checkbox.addEventListener("change", () => {
            item.checked = checkbox.checked;
            alert(
              `Checklist ${item.item}: ${checkbox.checked ? "Done" : "Not Done"}`,
            );
          });
          const label = document.createElement("label");
          label.textContent = "Complete?";
          label.htmlFor = checkbox.id;
          checkDiv.appendChild(checkbox);
          checkDiv.appendChild(label);
          btn.appendChild(checkDiv);
        }

        if (typeof item.onclick === "function") {
          btn.addEventListener("click", item.onclick);
        }

        groupDiv.appendChild(btn);
        if (item.badge) {
          updateBadge(item.item, item.badge.value, item.badge.color);
        }
      });
      bar.appendChild(groupDiv);
    });
  }

  function updateBadge(id, value, color = "#007bff") {
    const badge = document.getElementById(`badge_${id}`);
    if (!badge) return;

    const displayValue =
      value !== undefined && value !== null && value !== "" ? value : "";
    badge.innerHTML = `<span class="badge-text">${displayValue}</span>`;
    badge.style.display = displayValue ? "inline-block" : "none";
    badge.style.backgroundColor = color;

    // Adjust styling for non-numeric badges
    if (typeof value !== "number") {
      badge.style.minWidth = "auto";
      badge.style.padding = "0 6px";
    }
  }

  function updateProgress(id, percent) {
    const progress = document.getElementById(`progress_${id}`);
    if (progress) {
      const clamped = Math.min(percent, 100);
      progress.style.width = `${clamped}%`;
      progress.title = `${percent}%`;
    }
  }

  function updateStatus(id, status) {
    const div = document.getElementById(`status_${id}`);
    if (div) {
      div.textContent = status;
      div.dataset.status = status.toLowerCase();
    }
  }

  function updateChecklist(id, checked) {
    const box = document.getElementById(`check_${id}`);
    if (box) box.checked = checked;
  }

  function updateItemText(id, newText) {
    const item = document.querySelector(`#${id} .labelText`);
    if (item) {
      item.textContent = newText;
    }
  }

  // Language switcher functions
  function toggleLang() {
    const currentLang = localStorage.getItem("language") || "en";
    const newLang = currentLang === "en" ? "th" : "en";
    setLanguage(newLang);
    switchLang(newLang);
    window.lang = newLang;
  }

  function setLanguage(lang) {
    localStorage.setItem("language", lang);
    updateSwitch(lang);
    console.log("Language set to:", lang);
  }

  function updateSwitch(lang) {
    const switchEl = document.getElementById("slideSwitch");
    if (switchEl) {
      switchEl.classList.toggle("active", lang === "th");
      //document.getElementById('langText').textContent = lang === 'en' ? 'English' : 'Thai';
    }
  }

  function switchLang_01(lang) {
    window.lang = lang;
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    (window.formStack || []).forEach((panelId) => {
      if (panelId === "gen" && typeof genpaN === "function")
        genpaN(window.userid);
      else if (panelId === "profile" && typeof profilepaN === "function")
        profilepaN(window.userid);
    });

    if (
      document.getElementById("summan") &&
      typeof renderSchemaStructureToSumman === "function"
    ) {
      renderSchemaStructureToSumman(window.bucket, "gform", lang);
    }

    if (
      document.getElementById("jumperhelper") &&
      typeof updateJumperHelperWithUnanswered === "function"
    ) {
      updateJumperHelperWithUnanswered(
        QSummary(window.bucket).summary,
        window.bucket,
      );
    }
  }
  function switchLang_02_no_cache(lang) {
    // Set the new language
    window.lang = lang;

    // Update UI language buttons
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    // Refresh all forms in the stack using smart loading
    formStack.forEach((panelId) => {
      if (panelId === "gen" || panelId === "profile") {
        // Try to load from localStorage first

        // Fall back to server if no cached data
        console.log(`⚡ No cached data, loading ${panelId} from server`);
        if (panelId === "gen") genpaN(userid);
        else if (panelId === "profile") profilepaN(userid);
      }
    });

    // Update summary panels
    updateSummaryPanels(lang);
  }
  function switchLangXX(lang) {
    // Store original setting
    const originalLoadSetting = window.loadFromLocalStorage;

    // Force localStorage-only mode for language switching
    window.loadFromLocalStorage = true;
    // Set the new language
    window.lang = lang;

    // Update UI language buttons
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    // Refresh all forms in the stack using smart loading
    formStack.forEach((panelId) => {
      if (panelId === "gen" || panelId === "profile") {
        // Try to load from localStorage first

        // Fall back to server if no cached data
        console.log(`⚡ No cached data, loading ${panelId} from server`);
        if (panelId === "gen") genpaN(userid);
        else if (panelId === "profile") profilepaN(userid);
      }
    });
    // Restore original setting
    window.loadFromLocalStorage = originalLoadSetting;
    // Update summary panels
    updateSummaryPanels(lang);
  }
  function switchLang(lang) {
    // Store original setting
    const originalLoadSetting = window.loadFromLocalStorage;

    // Force localStorage-only mode for language switching
    window.loadFromLocalStorage = true;

    // Set the new language
    window.lang = lang;

    // Update UI language buttons
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    // Refresh all forms in the stack using cached data only
    formStack.forEach((panelId) => {
      if (panelId === "gen" || panelId === "profile") {
        if (panelId === "gen") {
          processCachedDataFromLocalStorage("gen", "gform", "bucket");
        } else if (panelId === "profile") {
          processCachedDataFromLocalStorage("profile", "pro", "cup");
        }
      }
    });

    // Update summary panels
    //updateSummaryPanels(lang);

    // Restore original setting
    window.loadFromLocalStorage = originalLoadSetting;
  }
  // Expose functions to window
  window.updateProgress = updateProgress;
  window.updateStatus = updateStatus;
  window.updateItemText = updateItemText;
  window.updateBadge = updateBadge;
  window.renderMenu = renderMenu;
  window.toggleLang = toggleLang;
  window.setLanguage = setLanguage;

  window.clearAllBadges = function () {
    document.querySelectorAll(".badge").forEach((badge) => {
      badge.textContent = "";
      badge.style.display = "none";
    });
  };

  // Initialize
  renderMenu();
})();
