function moveXY(id, x, y) {
    const el = document.getElementById(id);
    if (el) {
        el.style.position = el.style.position || 'absolute';
        el.style.left = typeof x === 'number' ? x + 'px' : x;
        el.style.top = typeof y === 'number' ? y + 'px' : y;
    }
    return el;
}
function toast(msgHTML, pos = {}, style = {}, timeclose = 2000) {
        const toastCount = panelStack.length + 1;
        const id = "toast_" + toastCount;
        const position = (pos.pos || "TR").toUpperCase();
        const slideDir = pos.slide || posToDir(position);
        const defaultWidth = 300;
        const defaultHeight = 80;

        // Use style.width if provided, otherwise use defaultWidth
        const panelWidth = style.width || defaultWidth;
        const panelHeight = style.height || defaultHeight;

        createPanel(id, position, slideDir, panelWidth, panelHeight, {
            toast: true,
            bodyContent: `<div style="margin-top: -10px;">
        <div style="display:flex; align-items:center; gap:10px;">
          <span style="font-size:20px;"> </span>
          <div>
            <div style="font-size:12px;"></div>
            <div style="margin-top:10px;font-size:12px;">${msgHTML}</div>
          </div>
        </div>
      </div>`,
            timeClose: timeclose,
            noDrag: true,
        });

        const panel = document.getElementById(id);
        if (panel && style.background) {
            panel.querySelector(".panel-body").style.background =
                style.background;
        }
        if (panel && style.color) {
            panel.querySelector(".panel-body").style.color = style.color;
        }
    }