/*  checklisth.js  – horizontal checklist only
    Assumes page already has:
        <div id="rail"></div>
        <div id="counter">0 of 5</div>
    Labels are read from <div id="labels" style="display:none">…</div>
*/
(function () {
  /* ---------- helpers ---------- */
  function $(sel) { return document.querySelector(sel); }

  function toggle(node) {
    node.classList.toggle('checked');
    updateCounter();
  }

  function updateCounter() {
    var checked = rail.querySelectorAll('.node.checked').length;
    counter.textContent = checked + ' of ' + rail.querySelectorAll('.node').length;
  }

  /* ---------- setup ---------- */
  var rail   = $('#rail');
  var counter= $('#counter');

  /* inject required CSS once */
  if (!document.querySelector('#checklisth-css')) {
    var css = document.createElement('style');
    css.id  = 'checklisth-css';
    css.textContent =
      '#rail{position:relative;width:400px;height:40px;margin:60px auto 40px}' +
      '#line{position:absolute;top:50%;left:0;right:0;height:4px;background:#bbb;transform:translateY(-50%);z-index:1}' +
      '.node{position:absolute;top:50%;width:28px;height:28px;border-radius:50%;border:3px solid #555;background:#fff;cursor:pointer;transform:translate(-50%,-50%);z-index:2;transition:background .2s;text-align:center;line-height:28px}' +
      '.node.checked{background:#4caf50}' +
      '.node .tick{display:none;color:#fff;font-size:18px}' +
      '.node.checked .tick{display:inline}' +
      '.label{position:absolute;top:100%;left:50%;transform:translateX(-50%);margin-top:8px;font-size:14px;white-space:nowrap}' +
      '#counter{text-align:center;margin-top:20px;font-size:18px}';
    document.head.appendChild(css);
  }

  /* ---------- build nodes ---------- */
  var railWidth   = rail.offsetWidth;
  var labelsRaw   = ($('#labels') ? $('#labels').textContent.trim().split(/\s*\n\s*/) : []);
  var NODE_COUNT  = labelsRaw.length || 5;
  var step        = railWidth / (NODE_COUNT - 1 || 1);

  /* line */
  var line = document.createElement('div');
  line.id = 'line';
  rail.appendChild(line);

  /* circles + labels */
  for (var i = 0; i < NODE_COUNT; i++) {
    var node = document.createElement('div');
    node.className = 'node';
    node.style.left = (i * step) + 'px';
    node.innerHTML = '<span class="tick">&#10003;</span>';
    node.onclick = function () { toggle(this); };
    rail.appendChild(node);

    var lbl = document.createElement('div');
    lbl.className = 'label';
    lbl.textContent = labelsRaw[i] || ('Item ' + (i + 1));
    node.appendChild(lbl);
  }

  updateCounter();

  /* ---------- API helpers (console) ---------- */
  window.checklisth = {
    check  : function (idx) { rail.querySelectorAll('.node')[idx].classList.add('checked');    updateCounter(); },
    uncheck: function (idx) { rail.querySelectorAll('.node')[idx].classList.remove('checked'); updateCounter(); },
    setLabel: function (idx, txt) {
      var lbl = rail.querySelectorAll('.node')[idx].querySelector('.label');
      if (lbl) lbl.textContent = txt;
    }
  };
})();