 const menuData = [
  {
    group: "Main",
    items: [
      {
        item: "A1",
        icon: "⬇️",
        text: "KTB2025",
        badgeCount: 1,
        progress: 45,
        status: "in progress",
        onclick: () => alert("Welcome clicked")
      }
    ]
  },
  {
    group: "Tracking",
    items: [
      {
        item: "assessment",
        icon: "📦",
        text: "Assessment",
        status: "pending",
        progress: 10,
        onclick: () =>genpaN(userid)},
      {
        item: "Profile",
        icon: "💳",
        text: "Profile",
        status: "done",
        progress: 100,
        onclick: () => profilepaN(userid)
      }
    ]
  },
  {
        group: "Actions",
        items: [
          {
            item: "save",
            icon: "💾",
            text: "Save",
            badgeCount: 2,
            onclick: () => saveToServerM(userid)
          },
          {
            item: "settings",
            icon: "⚙️",
            text: "Settings",
            badgeCount: 1,
            onclick: () => alert("Settings clicked")
          }
        ]
      }, {
        group: "User Actions",
        items: [
          {
            item: "profileX",
            icon: "👤",
            text: "User Profile",
            badgeCount: 2,
            onclick: () => alert("Profile clicked")
          },
          {
            item: "settings",
            icon: "⚙️",
            text: "Settings",
            badgeCount: 1,
            onclick: () => alert("Settings clicked")
          }
        ]
      }
];

function createDiv() {
  const wrapper = document.createElement('div');
  wrapper.innerHTML = `
    <div id="triggerIcon" title="Open Menu"></div>
    <div id="smartBar">
      <!-- Menu Groups -->
      <div id="smartBarIn"></div>
    </div>
  `;
  //document.getElementById('app').appendChild(wrapper);
  document.body.appendChild(wrapper);

}

function createDiv1() {
  const wrapper = document.createElement('div');
  wrapper.innerHTML = `
   <!-- Bottom Bar -->
  <div class="bottomBar">
    <button onclick="runRandomUpdates()">🔁 Random Test All</button>
<!-- Language Toggle -->
  <div class="menuItem lang-toggle" id="languageToggleRow">
    <div class="lang-label">Language</div>
    <label class="lang-switch">
      <input type="checkbox" id="langToggle">
      <span class="lang-slider"></span>
    </label>
    <div class="lang-label" id="langText">EN</div>
  </div>

    <div class="statusDisplay">
      <div class="statusDot greenDot"></div>
      <div>Status: Ready</div>
      <div class="statusDot redDot"></div>
    </div>
    <div class="bottomRow">
      <div id="avatar"></div>
      <div id="loginToggle" onclick="toggleLogin()">Log On</div>
    </div>
  </div>
</div>
  `;
//  document.getElementById('app').appendChild(wrapper);
  document.body.appendChild(wrapper);

  //renderMenu();
}
function renderMenu() {
  const bar = document.getElementById('smartBarIn');
  bar.innerHTML = '';

  menuData.forEach(group => {
    const groupDiv = document.createElement('div');
    groupDiv.className = 'menuGroup';

    const title = document.createElement('div');
    title.className = 'groupTitle';
    title.textContent = group.group;
    groupDiv.appendChild(title);

    group.items.forEach(item => {
      const btn = document.createElement('div');
      btn.className = 'menuButton';
      btn.id = item.item;

      const topRow = document.createElement('div');
      topRow.className = 'menuTop';
      topRow.innerHTML = `
        <span class="icon">${item.icon || ''}</span>
        <span class="labelText">${item.text || item.item}</span>
        <span class="badge" id="badge_${item.item}">${item.badgeCount || ''}</span>
      `;
      btn.appendChild(topRow);

      // STATUS
      if (item.status) {
        const status = document.createElement('div');
        status.className = 'statusLabel';
        status.setAttribute("id", `status_${item.item}`);
        status.setAttribute("data-status", item.status.toLowerCase());
        status.textContent = item.status;
        btn.appendChild(status);
      }

      // PROGRESS BAR
      if (typeof item.progress === 'number') {
        const progressBar = document.createElement('div');
        progressBar.className = 'progressBar';

        const progressInner = document.createElement('div');
        progressInner.className = 'progressInner';
        progressInner.style.width = `${item.progress}%`;
        progressInner.id = `progress_${item.item}`;

        progressBar.appendChild(progressInner);
        btn.appendChild(progressBar);
      }

      // CHECKLIST
      if (item.checklist) {
        const checkDiv = document.createElement('div');
        checkDiv.className = 'checklistItem';

        const checkbox = document.createElement('input');
        checkbox.type = 'checkbox';
        checkbox.checked = !!item.checked;
        checkbox.id = `check_${item.item}`;
        checkbox.addEventListener('change', () => {
          item.checked = checkbox.checked;
          alert(`Checklist ${item.item}: ${checkbox.checked ? 'Done' : 'Not Done'}`);
        });

        const label = document.createElement('label');
        label.textContent = "Complete?";
        label.setAttribute("for", checkbox.id);

        checkDiv.appendChild(checkbox);
        checkDiv.appendChild(label);
        btn.appendChild(checkDiv);
      }

      if (typeof item.onclick === 'function') {
        btn.addEventListener('click', item.onclick);
      }

      groupDiv.appendChild(btn);
      updateBadge(item.item, item.badgeCount || 0);
    });

    bar.appendChild(groupDiv);
  });
}

// UPDATE FUNCTIONS
function updateBadge(id, count) {
  const badge = document.getElementById(`badge_${id}`);
  if (!badge) return;
  badge.textContent = count;
  badge.style.display = count > 0 ? 'inline-block' : 'none';
}

function updateProgress(id, percent) {
  const progress = document.getElementById(`progress_${id}`);
  if (progress) progress.style.width = `${percent}%`;
}

function updateStatus(id, status) {
  const statusDiv = document.getElementById(`status_${id}`);
  if (statusDiv) {
    statusDiv.textContent = status;
    statusDiv.setAttribute('data-status', status.toLowerCase());
  }
}

function updateChecklist(id, isChecked) {
  const checkbox = document.getElementById(`check_${id}`);
  if (checkbox) checkbox.checked = !!isChecked;
}

// Test all updates
function runRandomUpdates() {
  menuData.forEach(group => {
    group.items.forEach(item => {
      const randBadge = Math.floor(Math.random() * 5);
      const randProgress = Math.floor(Math.random() * 101);
      const statuses = ['pending', 'in progress', 'start', 'done'];
      const randStatus = statuses[Math.floor(Math.random() * statuses.length)];
      const randCheck = Math.random() > 0.5;

      updateBadge(item.item, randBadge);
      if ('progress' in item) updateProgress(item.item, randProgress);
      if ('status' in item) updateStatus(item.item, randStatus);
      if (item.checklist) updateChecklist(item.item, randCheck);
    });
  });
}
function initLanguageToggle() {
    const toggle = document.getElementById('langToggle');
    const langText = document.getElementById('langText');
    const lang = localStorage.getItem('language') || 'EN';

    toggle.checked = lang === 'TH';
    langText.textContent = lang;

    toggle.addEventListener('change', () => {
      const selectedLang = toggle.checked ? 'TH' : 'EN';
      localStorage.setItem('language', selectedLang);
      langText.textContent = selectedLang;
    });
  }

  let loggedIn = false;
  function toggleLogin() {
    loggedIn = !loggedIn;
    document.getElementById('loginToggle').textContent = loggedIn ? 'Log Off' : 'Log On';
  }

  //initLanguageToggle();