function showUserLangPanel(divId = "langswitcher", scale = 1, fontSize = "18px") {
  const currentLang = window.lang || localStorage.getItem('language') || 'en';
  window.lang = currentLang;

  const container = document.getElementById(divId);
  if (!container) return;

  container.innerHTML = `
    <div style="line-height:1.5; text-align: center; transform: scale(${scale}); transform-origin: top left; display: inline-block; font-size: ${fontSize};">
      <div class="lang-slide-option" data-lang="en">EN</div>
      <div class="lang-slide-option" data-lang="th">TH</div>
      <div class="lang-slide-indicator"></div>
    </div>
  `;

  // Scale the whole switcher
  container.style.transform = `scale(${scale})`;
  container.style.transformOrigin = "top left";
  container.style.display = "inline-block"; // avoid layout collapsing

  // Events
  const switchEl = document.getElementById("slideSwitch");
  switchEl.addEventListener('click', toggleLang);
  switchEl.addEventListener('dblclick', () => {
    localStorage.removeItem("language");
    location.reload();
  });

  updateSwitch(currentLang);
  addLangStyles();

  function toggleLang() {
    const current = localStorage.getItem('language') || 'en';
    const next = current === 'en' ? 'th' : 'en';
    setLanguage(next);
    switchLang(next);
    window.lang = next;
  }

  function setLanguage(lang) {
    localStorage.setItem('language', lang);
    updateSwitch(lang);
    console.log('Language set to:', lang);
  }

  function updateSwitch(lang) {
    const el = document.getElementById('slideSwitch');
    if (el) el.classList.toggle('active', lang === 'th');
  }

  function switchLang(lang) {
    window.lang = lang;
    document.querySelectorAll(".lang-btn").forEach((btn) => {
      btn.classList.toggle("active", btn.dataset.lang === lang);
    });

    (window.formStack || []).forEach((panelId) => {
      if (panelId === "gen" && typeof genpaN === "function") genpaN(window.userid);
      else if (panelId === "profile" && typeof profilepaN === "function") profilepaN(window.userid);
    });

    if (document.getElementById("summan") && typeof renderSchemaStructureToSumman === "function") {
      renderSchemaStructureToSumman(window.bucket, "gform", lang);
    }

    if (document.getElementById("jumperhelper") && typeof updateJumperHelperWithUnanswered === "function") {
      updateJumperHelperWithUnanswered(QSummary(window.bucket).summary, window.bucket);
    }
  }

  function addLangStyles() {
    const css = `
      .lang-switcher-slide {
  font-family: Arial, sans-serif;
  position: relative;
  display: inline-flex; /* changed from block */
  width: 120px;
  height: auto;         /* let height grow */
  background: #f0f0f0;
  border-radius: 20px;
  overflow: visible;    /* allow content to spill out */
  cursor: pointer;
  align-items: center;
}

.lang-slide-option {
  position: relative;    /* instead of absolute */
  flex: 1;
  padding: 10px 0;
  display: flex;
  align-items: center;
  justify-content: center;
  color: #666;
  
  font-size: 28px;       /* Make it larger */
  z-index: 2;
}

      

      .lang-switcher-slide:not(.active) .lang-slide-option:nth-child(1),
      .lang-switcher-slide.active .lang-slide-option:nth-child(2) {
        color: white;
      }

      .lang-slide-indicator {
        position: absolute;
        width: 50%;
        height: 100%;
        background: #007bff;
        border-radius: 20px;
        transition: all 0.3s ease;
        left: 0;
        z-index: 1;
      }
      .lang-switcher-slide.active .lang-slide-indicator {
        left: 50%;
        background: #28a745;
      }

      .lang-btn.active {
        background-color: blue;        
        color: white;
      }
    `;
    const style = document.createElement('style');
    style.textContent = css;
    document.head.appendChild(style);
  }
}
