function circleProgress(divId, label, percent) {
    try {
        // Validate inputs
        percent = Math.max(0, Math.min(100, parseFloat(percent) || 0));
        label = label || 'Progress';
        const container = document.getElementById(divId);
        
        if (!container) {
            console.error(`Div with ID "${divId}" not found`);
            return;
        }

        // Generate unique IDs for elements
        const circleId = `progressCircle_${divId}_${Date.now()}`;
        const labelId = `progressLabel_${divId}_${Date.now()}`;

        // Create SVG and text elements
        container.innerHTML = `
            <div style="display: flex; flex-direction: column; align-items: center;">
                <svg width="120" height="120">
                    <circle cx="60" cy="60" r="50" stroke="#eee" stroke-width="12" fill="none" />
                    <circle id="${circleId}" cx="60" cy="60" r="50" stroke="#4caf50" 
                            stroke-width="12" fill="none" stroke-linecap="round"
                            transform="rotate(-90 60 60)"
                            stroke-dasharray="314" stroke-dashoffset="314" />
                </svg>
                <div id="${labelId}" style="width: 160px; text-align: center; margin-top: 15px; font-size: 1.2em; font-weight: bold;">
                    <div>${label}</div>
                    <div>${Math.round(percent)}%</div>
                </div>
            </div>
        `;

        // Get DOM elements
        const circle = document.getElementById(circleId);
        const labelElement = document.getElementById(labelId).lastElementChild;

        if (!circle || !labelElement) {
            console.error("Failed to create progress elements");
            return;
        }

        // Animate progress
        const radius = 50;
        const circumference = 2 * Math.PI * radius;
        const duration = 1500;
        const start = performance.now();

        // Set color based on completion
        const color = percent === 100 ? "#4CAF50" : 
                     percent >= 50 ? "#FFC107" : "#F44336";
        circle.style.stroke = color;

        function animate(time) {
            const elapsed = time - start;
            const progress = Math.min(elapsed / duration, 1);
            const value = percent * progress;
            const offset = circumference - (value / 100) * circumference;
            circle.style.strokeDashoffset = offset;
            labelElement.textContent = `${Math.round(value)}%`;
            if (progress < 1) requestAnimationFrame(animate);
        }

        requestAnimationFrame(animate);
    } catch (error) {
        console.error("Error creating circle progress:", error);
    }
}