function progressbar(divid, label, percent, color, isVertical = false) {
    const container = document.getElementById(divid);
    if (!container) {
        console.error(`Element with ID ${divid} not found`);
        return;
    }

    percent = Math.max(0, Math.min(100, percent));

    const progressWrapper = document.createElement('div');
    progressWrapper.className = isVertical ? 'vertical-progress-container' : 'horizontal-progress-container';

    const progressBar = document.createElement('div');
    progressBar.className = isVertical ? 'vertical-progress-bar' : 'horizontal-progress-bar';
    progressBar.style.backgroundColor = color || '#4CAF50';
    progressBar.style[isVertical ? 'height' : 'width'] = '0%'; // Start at 0 for animation

    const labelElement = document.createElement('div');
    labelElement.className = isVertical ? 'vertical-progress-label' : 'horizontal-progress-label';
    labelElement.textContent = label ? `${label}: ${percent}%` : `${percent}%`;

    progressWrapper.appendChild(progressBar);
    container.appendChild(labelElement);
    container.appendChild(progressWrapper);

    // Trigger animation
    setTimeout(() => {
        progressBar.style[isVertical ? 'height' : 'width'] = `${percent}%`;
    }, 100);
}