// toggleExpandPanel.js
function initToggleExpandDown(options = {}) {
  const {
    panelId = 'miniPanel',
    avatarId = 'dragAvatar',
    externalAvatarId = 'externalAvatar',
    expandedHeight = 600,
    expandedWidth = 220,
    collapsedHeight = 60,
    collapsedWidth = 150
  } = options;

  const miniPanel = document.getElementById(panelId);
  const dragAvatar = document.getElementById(avatarId);
  const externalAvatar = document.getElementById(externalAvatarId);

  function toggleExpandDown() {
  const isExpanded = miniPanel.classList.contains('expanded');

  if (!isExpanded) {
    const panelBottom = miniPanel.offsetTop + expandedHeight;
    const screenHeight = window.innerHeight;

    if (panelBottom > screenHeight) {
      alert("Will over screen edge!");
    }

    miniPanel.style.height = expandedHeight + 'px';
    miniPanel.style.width = expandedWidth + 'px';
  } else {
    miniPanel.style.height = collapsedHeight + 'px';
    miniPanel.style.width = collapsedWidth + 'px';
  }

  miniPanel.classList.toggle('expanded');
}


  function makeDraggable(el) {
    let offsetX = 0, offsetY = 0, isDragging = false;

    el.addEventListener('mousedown', (e) => {
      isDragging = true;
      offsetX = e.clientX - el.offsetLeft;
      offsetY = e.clientY - el.offsetTop;
      el.style.cursor = 'grabbing';
      e.preventDefault();
    });

    document.addEventListener('mousemove', (e) => {
      if (isDragging) {
        el.style.left = `${e.clientX - offsetX}px`;
        el.style.top = `${e.clientY - offsetY}px`;
      }
    });

    document.addEventListener('mouseup', () => {
      isDragging = false;
      el.style.cursor = 'grab';
    });
  }

  makeDraggable(dragAvatar);        // avatar drags the panel
  makeDraggable(miniPanel);         // panel itself also draggable
  makeDraggable(externalAvatar);    // external avatar is independently draggable

  externalAvatar.ondblclick = () => alert('hi');

  // Expose globally if needed
  window.toggleExpandDown = toggleExpandDown;
}
