function createDiv() {
            const wrapper = document.createElement('div');
            wrapper.innerHTML = `
                  <div id="menuContainer" class="menu-container"></div>

            `;
            document.body.appendChild(wrapper);
        }
   
    

        // Complete menu data structure with actions
        const menuData = [
            {
                group: "User Account",
                items: [
                    {
                        id: "profile",
                        icon: "👤",
                        text: "My Profile",
                        badgeCount: 2,
                        onClick: () => {
                            alert("Opening your profile...");
                            // You would replace this with actual profile opening logic
                            console.log("Profile opened");
                        }
                    },
                    {
                        id: "settings",
                        icon: "⚙️",
                        text: "Account Settings",
                        badgeCount: 1,
                        onClick: () => {
                            alert("Navigating to settings...");
                            // Actual settings navigation would go here
                            console.log("Settings opened");
                        }
                    }
                ]
            },
            {
                group: "Notifications",
                items: [
                    {
                        id: "messages",
                        icon: "✉️",
                        text: "Messages",
                        badgeCount: 5,
                        onClick: () => {
                            alert("You have " + this.badgeCount + " new messages");
                            // Would typically open messages view
                        }
                    },
                    {
                        id: "alerts",
                        icon: "🔔",
                        text: "Alerts",
                        badgeCount: 2,
                        onClick: () => {
                            alert("Showing your alerts");
                            // Alert display logic would go here
                        }
                    },
                    {
                        id: "updates",
                        icon: "🔄",
                        text: "System Updates",
                        badgeCount: 0,
                        onClick: () => {
                            alert("Checking for updates...");
                            // Update check logic
                        }
                    }
                ]
            },
            {
                group: "Actions",
                items: [
                    {
                        id: "logout",
                        icon: "🚪",
                        text: "Log Out",
                        badgeCount: 0,
                        onClick: () => {
                            if (confirm("Are you sure you want to log out?")) {
                                alert("Logging out...");
                                // Actual logout logic
                            }
                        }
                    }
                ]
            }
        ];

        // Render the menu with groups and actions
        function renderMenu() {
            const container = document.getElementById('menuContainer');
            container.innerHTML = '';
            
            menuData.forEach(group => {
                // Create group container
                const groupDiv = document.createElement('div');
                groupDiv.className = 'menu-group';
                
                // Add group title
                const title = document.createElement('div');
                title.className = 'menu-group-title';
                title.textContent = group.group;
                groupDiv.appendChild(title);
                
                // Add menu items
                group.items.forEach(item => {
                    const itemDiv = document.createElement('div');
                    itemDiv.className = 'menu-item';
                    
                    itemDiv.innerHTML = `
                        <span class="menu-icon">${item.icon}</span>
                        <span class="menu-text">${item.text}</span>
                        <span class="badge" id="badge-${item.id}"></span>
                    `;
                    
                    // Attach click handler
                    itemDiv.addEventListener('click', () => {
                        item.onClick();
                        // You could add analytics or other side effects here
                        console.log(`Clicked: ${item.text}`);
                    });
                    
                    groupDiv.appendChild(itemDiv);
                });
                
                container.appendChild(groupDiv);
            });
            
            // Update all badge displays
            updateAllBadges();
        }

        // Update a specific badge
        function updateBadge(itemId, count) {
            const badge = document.getElementById(`badge-${itemId}`);
            if (badge) {
                badge.textContent = count;
                badge.style.display = count > 0 ? 'inline-block' : 'none';
                
                // Update in menuData
                menuData.forEach(group => {
                    const item = group.items.find(i => i.id === itemId);
                    if (item) item.badgeCount = count;
                });
            }
        }

        // Update all badges from current data
        function updateAllBadges() {
            menuData.forEach(group => {
                group.items.forEach(item => {
                    updateBadge(item.id, item.badgeCount);
                });
            });
        }

        // Randomize all badges
        function randomizeBadges() {
            menuData.forEach(group => {
                group.items.forEach(item => {
                    const randomCount = Math.floor(Math.random() * 10);
                    updateBadge(item.id, randomCount);
                });
            });
        }

        // Add a notification to the messages badge
        function addNotification() {
            const messages = menuData.flatMap(g => g.items).find(i => i.id === 'messages');
            if (messages) {
                updateBadge('messages', messages.badgeCount + 1);
            }
        }

        // Clear all badges
        function clearAllBadges() {
            menuData.forEach(group => {
                group.items.forEach(item => {
                    updateBadge(item.id, 0);
                });
            });
        }

        // Initialize
           createDiv();
         renderMenu();
        
        // Set up button handlers
       