function makeDiv(divId) {
    const div = document.createElement('div');
    div.id = divId;
    document.body.appendChild(div);
    return div;
}

function moveDivXY(divId, left, top = left) {
    const div = document.getElementById(divId);
    if (!div) return;
    
    div.style.position = 'absolute';
    div.style.left = typeof left === 'string' ? left : `${left}px`;
    div.style.top = typeof top === 'string' ? top : `${top}px`;
}

function setDivWH(divId, width, height = width) {
    const div = document.getElementById(divId);
    if (!div) return;
    
    div.style.width = typeof width === 'string' ? width : `${width}px`;
    div.style.height = typeof height === 'string' ? height : `${height}px`;
}
// Function to move a div to a specified position in a 3x3 grid
function moveDiv(divId, position) {
    const div = document.getElementById(divId);
    if (!div) return; // Exit if div not found
    
    // Reset position
    div.style.position = 'absolute';
    
    // Define grid positions (assuming viewport units for responsiveness)
    const positions = {
        'TL': { top: '0%', left: '0%' },
        'TC': { top: '0%', left: '50%', transform: 'translateX(-50%)' },
        'TR': { top: '0%', right: '0%' },
        'CL': { top: '50%', left: '0%', transform: 'translateY(-50%)' },
        'CC': { top: '50%', left: '50%', transform: 'translate(-50%, -50%)' },
        'CR': { top: '50%', right: '0%', transform: 'translateY(-50%)' },
        'BL': { bottom: '0%', left: '0%' },
        'BC': { bottom: '0%', left: '50%', transform: 'translateX(-50%)' },
        'BR': { bottom: '0%', right: '0%' }
    };
    
    const pos = positions[position.toUpperCase()];
    if (!pos) return; // Exit if invalid position
    
    // Apply position styles
    for (let [key, value] of Object.entries(pos)) {
        div.style[key] = value;
    }
}

// Function to set innerHTML of a div
function setToDiv(divId, innerHTML) {
    const div = document.getElementById(divId);
    if (div) {
        div.innerHTML = innerHTML;
    }
}