(function () {
function show(e){
    const rect = e.target.getBoundingClientRect();
    const pos  = e.target.dataset.pos;
    const vw   = window.innerWidth;
    const vh   = window.innerHeight;

    tooltip.textContent = 'Tooltip for ' + pos;
    tooltip.style.visibility = 'visible';
    tooltip.style.transform = '';

    /* quick measure */
    tooltip.style.left = '-9999px';
    tooltip.style.top  = '-9999px';
    const tipW = tooltip.offsetWidth  || 60;
    const tipH = tooltip.offsetHeight || 30;

    let left, top, arrowDir;
/* inside show(), after  const rect = e.target.getBoundingClientRect(); */

    switch(pos){
        /* TOP ROW – tooltip ABOVE, arrow DOWN */
        case 'BL':
            left   = rect.left;
            top    = rect.top - tipH - arrowSize;
            arrowDir='top';
            break;
        case 'BC':
            left   = rect.left + rect.width/2 - tipW/2;
            top    = rect.top - tipH - arrowSize;
            arrowDir='top';
            break;
        case 'BR':
            left   = rect.right - tipW;
            top    = rect.top - tipH - arrowSize;
            arrowDir='top';
            break;

        /* CENTER ROW */
        case 'CL':
            left   = rect.left + tipW + arrowSize*2;
            top    = rect.top + rect.height/2 - tipH/2;
            arrowDir='left';
            break;
        case 'CC':
            left   = rect.left + rect.width/2 - tipW/2;
            top    = rect.top - tipH - arrowSize;
            arrowDir='top';
            break;
        case 'CR':
            left   = rect.left - tipW - arrowSize;
            top    = rect.top + rect.height/2 - tipH/2;
            arrowDir='right';
            break;

        /* BOTTOM ROW – tooltip BELOW, arrow UP */
        case 'TL':
            left   = rect.left;
            top    = rect.bottom + arrowSize;
            arrowDir='bottom';
            break;
        case 'TC':
            left   = rect.left + rect.width/2 - tipW/2;
            top    = rect.bottom + arrowSize;
            arrowDir='bottom';
            break;
        case 'TR':
            left   = rect.right - tipW;
            top    = rect.bottom + arrowSize;
            arrowDir='bottom';
            break;

        /* horizontal badges (right/left) */
        case 'TTR':
           left   = rect.left - tipW - arrowSize;
            top    = rect.top + rect.height/2 - tipH/2;
            arrowDir='right';
            break;
        case 'TTL':
             left   = rect.right + arrowSize;
            top    = rect.top + rect.height/2 - tipH/2;
            
            arrowDir='left';
            
            break;
             case 'TB': {
    /* 1. above or below? */
    const useTop = rect.top + rect.height / 2 < vh / 2;

    /* 2. left / center / right ? */
    const center = rect.left + rect.width / 2;
    let align = 'center';
    if (center < vw / 3)        align = 'left';
    else if (center > vw * 2/3) align = 'right';

    /* 3. compute base coordinates */
    if (useTop) {                                 // tooltip BELOW
        top = rect.bottom + arrowSize;        
        arrowDir = 'bottom';
    } else {                                      // tooltip ABOVE
        
        top = rect.top - tipH - arrowSize;
        arrowDir = 'top';
    }

    if (align === 'left') {
        left = rect.left;
        tooltip.style.transform = 'translateX(0)';
        styleEl.textContent =
          `#tooltip[data-arrow="${arrowDir}"]::after{left:25%;}`;
    } else if (align === 'right') {
        left = rect.right - tipW;
        tooltip.style.transform = 'translateX(0)';
        styleEl.textContent =
          `#tooltip[data-arrow="${arrowDir}"]::after{left:75%;}`;
    } else {                                      // center
        left = rect.left + rect.width / 2;
        tooltip.style.transform = 'translateX(-50%)';
        styleEl.textContent = '';                 // back to 50 %
    }
    break;
}
    
    }

    /* viewport clamp */
    left = Math.max(8, Math.min(left, vw - tipW - 8));
    top  = Math.max(8, Math.min(top,  vh - tipH - 8));

    tooltip.style.left = left + 'px';
    tooltip.style.top  = top  + 'px';
    tooltip.setAttribute('data-arrow', arrowDir);
}

function hide(){
    tooltip.style.visibility = 'hidden';
}
  function addStyle() {
  const style = document.createElement("style");
  style.innerHTML = `
     body{margin:0;font-family:system-ui;background:#f5f7fa}
    h1{margin:30px 0 0 30px}
    .demo-grid{
        display:grid;
        grid-template-columns:repeat(3,100px);
        gap:40px;
        place-content:center;
        margin-top:20vh;
    }
    .demo-grid div,
    .test{
        width:100px;
        height:40px;
        line-height:40px;
        text-align:center;
        background:#fff;
        border:2px solid #333;
        cursor:pointer;
        border-radius:4px;
        user-select:none;
    }
    
    .test1{position:absolute;left:1210px;top:610px;}
    .test2{position:absolute;left:980px;top:450px;}
    .test3{position:absolute;left:500px;top:600px;}
    .test4{position:absolute;left:900px;top:110px;}

    /* tooltip shell */
    #tooltip{
        position:fixed;
        background:#222;
        color:#fff;
        padding:6px 10px;
        border-radius:4px;
        font-size:13px;
        white-space:nowrap;
        pointer-events:none;
        z-index:9999;
        visibility:hidden;
    }
    /* arrows */
    #tooltip::after{
        content:'';
        position:absolute;
        width:0;height:0;
        border:6px solid transparent;
    }
    #tooltip[data-arrow="top"]::after{
        top:100%;left:50%;transform:translateX(-50%);
        border-top-color:#222;
    }
    #tooltip[data-arrow="bottom"]::after{
        bottom:100%;left:50%;transform:translateX(-50%);
        border-bottom-color:#222;
    }
    #tooltip[data-arrow="left"]::after{
        top:50%;left:-11px;transform:translateY(-50%);
        border-right-color:#222;
    }
    #tooltip[data-arrow="right"]::after{
        top:50%;right:-11px;transform:translateY(-50%);
        border-left-color:#222;
    }
  `;
  document.head.appendChild(style);
}
function createTooltip() {
  if (document.getElementById("tooltip")) return; // avoid duplicates

  const tooltip = document.createElement("div");
  tooltip.id = "tooltip";
  tooltip.setAttribute("role", "tooltip");
  tooltip.style.position = "fixed";
  tooltip.style.background = "#222";
  tooltip.style.color = "#fff";
  tooltip.style.padding = "6px 10px";
  tooltip.style.borderRadius = "4px";
  tooltip.style.fontSize = "13px";
  tooltip.style.whiteSpace = "nowrap";
  tooltip.style.pointerEvents = "none";
  tooltip.style.zIndex = "9999";
  tooltip.style.visibility = "hidden";
  tooltip.style.transition = "opacity 0.2s ease";

  document.body.appendChild(tooltip);
}

addStyle();
createTooltip()   
const tooltip = document.getElementById('tooltip');
const arrowSize = 6;
const styleEl = document.createElement('style');
document.head.appendChild(styleEl);
/* listeners */
document.querySelectorAll('[data-pos]').forEach(el=>{
    el.addEventListener('mouseenter', show);
    el.addEventListener('mouseleave', hide);
});
})();