async function addItemPanel() {
    const defaultBoard = JSON.stringify({ user: "", note: "", data: {} }, null, 2);

    function renderForm() {
        return `
        <style>
            .form-row { display: flex; gap: 10px; }
            .form-row > div { flex: 1; }
            textarea {
                width: 100%;
                min-height: 100px;
                font-family: monospace;
                font-size: 13px;
                padding: 6px;
                resize: vertical;
            }
        </style>
        <form id="addItemForm">
            <div><label for="itemId">ID:</label> <input type="text" id="itemId" required></div>
            <div><label for="itemName">Name:</label> <input type="text" id="itemName" required></div>
            <div class="form-row">
                <div>
                    <label for="itemFlag">Flag:</label>
                    <select id="itemFlag">
                        <option value="1" selected>1 (Active)</option>
                        <option value="0">0 (Hidden)</option>
                        <option value="3">3 (Deleted)</option>
                    </select>
                </div>
                <div>
                    <label for="itemKeeper">Keeper:</label>
                    <input type="text" id="itemKeeper" placeholder="Assigned by">
                </div>
            </div>
            <div class="form-row">
                <div><label for="itemBucket">Bucket:</label> <input type="text" id="itemBucket"></div>
                <div><label for="itemCup">Cup:</label> <input type="text" id="itemCup"></div>
            </div>
            <div>
                <label for="itemBoard">Board (JSON):</label>
                <textarea id="itemBoard">${defaultBoard}</textarea>
            </div>
            <button type="submit">Save Item</button>
        </form>
        <div id="itemMessage" class="message"></div>
        `;
    }

    function displayMessage(msg, isError = false) {
        const box = document.getElementById("itemMessage");
        if (box) {
            box.textContent = msg;
            box.style.color = isError ? "red" : "green";
        }
    }

    function closeAfterDelay(panelId, delay = 2000) {
        setTimeout(() => {
            closePanel(panelId);
            window.location.href = "index.html";
        }, delay);
    }

    if (typeof createPanel !== "function") {
        console.error("Missing createPanel() from micro2.js");
        return;
    }

    createPanel("addItemPanel", "CC", "ctc", 500, 600, {
        bodyContent: renderForm(),
        noFooter: true,
        title: "Add New Item"
    });

    const form = document.getElementById("addItemForm");
    if (form) {
        form.addEventListener("submit", async (e) => {
            e.preventDefault();

            const payload = {
                id: document.getElementById("itemId").value.trim(),
                name: document.getElementById("itemName").value.trim(),
                flag: parseInt(document.getElementById("itemFlag").value),
                bucket: document.getElementById("itemBucket").value.trim(),
                cup: document.getElementById("itemCup").value.trim(),
                board: document.getElementById("itemBoard").value.trim(),
                keeper: document.getElementById("itemKeeper").value.trim()
            };

            if (!payload.id || !payload.name) {
                displayMessage("ID and Name are required", true);
                return;
            }

            try {
                const res = await fetch("https://j.kunok.com/api62.php", {
                    method: "POST",
                    headers: { "Content-Type": "application/json" },
                    body: JSON.stringify({ data: payload })
                });

                const result = await res.json();
                if (!res.ok || result.error) throw new Error(result.error || "Unknown error");

                displayMessage(result.message || "Item saved");
                form.reset();
                closeAfterDelay("addItemPanel", 2000);
            } catch (err) {
                displayMessage("Error: " + err.message, true);
            }
        });
    }
}
