async function itemsListPanel(url = 'https://i.kunok.com/api62.php?action=list_all&fields=id,name,flag,timestamp,board') {
    let items = [];

    function renderItems() {
        if (!items.length) return `<div class="error">No items found</div>`;

        return `
            <style>
                .item-entry {
                    background: #fff;
                    padding: 12px;
                    border-radius: 6px;
                    margin-bottom: 10px;
                    border: 1px solid #ccc;
                    font-size: 14px;
                    cursor: pointer;
                    transition: background 0.2s;
                }
                .item-entry:hover {
                    background: #f8f8f8;
                }
                .item-entry pre {
                    background: #f5f5f5;
                    padding: 6px;
                    border-radius: 4px;
                    font-size: 12px;
                    overflow-x: auto;
                    margin-top: 4px;
                }
                .item-meta {
                    font-size: 12px;
                    color: #666;
                    margin-bottom: 4px;
                }
                .error {
                    color: red;
                    text-align: center;
                    margin: 20px;
                }
            </style>
            <div id="itemsList">
                ${items.map(item => `
                    <div class="item-entry" data-item-id="${item.id}">
                        <div><strong>ID:</strong> ${item.id}</div>
                        <div><strong>Name:</strong> ${item.name || 'N/A'}</div>
                        <div class="item-meta">Flag: ${item.flag} | Timestamp: ${item.timestamp}</div>
                        <div><strong>Board:</strong></div>
                        <pre>${item.boardRaw}</pre>
                        <div><strong>Board User:</strong> ${item.boardUser || 'N/A'}</div>
                        <div><strong>Keeper:</strong> ${item.keeper || 'N/A'}</div>
                    </div>
                `).join("")}
            </div>
        `;
    }
async function refreshSingleItem(itemId) {
    try {
        const res = await fetch(`https://i.kunok.com/api62.php?id=${encodeURIComponent(itemId)}`);
        const json = await res.json();
        if (!json.data) return;

        const item = json.data;
        let boardUser = "N/A";
        let boardRaw = "N/A";

        if (item.board && typeof item.board === "string") {
            try {
                const boardObj = JSON.parse(item.board);
                boardUser = boardObj.user || "N/A";
                boardRaw = JSON.stringify(boardObj, null, 2);
            } catch {
                boardRaw = "Invalid JSON";
            }
        }

        const box = document.querySelector(`.item-entry[data-item-id="${itemId}"]`);
        if (box) {
            box.innerHTML = `
                <div><strong>ID:</strong> ${item.id}</div>
                <div><strong>Name:</strong> ${item.name || 'N/A'}</div>
                <div class="item-meta">Flag: ${item.flag} | Timestamp: ${item.timestamp}</div>
                <div><strong>Board:</strong></div>
                <pre>${boardRaw}</pre>
                <div><strong>Board User:</strong> ${boardUser}</div>
                <div><strong>Keeper:</strong> ${item.keeper || 'N/A'}</div>
            `;

            // ✨ Add highlight effect
            box.style.transition = 'background-color 0.6s ease';
            box.style.backgroundColor = '#ffffcc';

            setTimeout(() => {
                box.style.backgroundColor = '#ffffff';
            }, 600);
        }
    } catch (err) {
        console.error("Error refreshing single item:", err);
    }
}


    function attachClickEvents() {
        const entries = document.querySelectorAll(".item-entry");
        entries.forEach(entry => {
            entry.addEventListener("click", () => {
                const itemId = entry.getAttribute("data-item-id");
                if (itemId && typeof updateItemPanelEX === "function") {
                    //closePanel("itemsListPanel");
                    //updateItemPanelEX(itemId);
                    //make call back
                    updateItemPanelEX(itemId, () => refreshSingleItem(itemId));

                } else {
                    alert("updateItemPanelEX(id) not available.");
                }
            });
        });
    }

    try {
        const response = await fetch(url);
        const result = await response.json();

        if (!result.data) throw new Error("No data found");

        items = result.data.map(item => {
            let boardUser = "N/A";
            let boardRaw = "N/A";

            if (item.board && typeof item.board === 'string') {
                try {
                    const boardObj = JSON.parse(item.board);
                    boardUser = boardObj.user || "N/A";
                    boardRaw = JSON.stringify(boardObj, null, 2);
                } catch (e) {
                    boardRaw = "Invalid JSON";
                }
            }

            return {
                ...item,
                boardUser,
                boardRaw
            };
        });

        const html = renderItems();

        if (typeof createPanel !== "function") {
            console.error("Missing createPanel() from micro2.js");
            return;
        }

        createPanel("itemsListPanel", "CC", "ctc", 600, 600, {
            bodyContent: html,
            noFooter: true,
            title: "Items List"
        });

        setTimeout(attachClickEvents, 100);
    } catch (err) {
        console.error("Error loading items:", err);
        createPanel("itemsListPanel", "CC", "ctc", 400, 200, {
            bodyContent: `<div class="error">${err.message}</div>`,
            noFooter: true,
            title: "Items List"
        });
    }
}




