function makeAnalogClock(targetId) {
  const target = document.getElementById(targetId);
  if (!target) return;

  target.innerHTML = `
    <div class="clock-containerS">
      <div id="clockScale" class="clock-scale">
        <div class="analog-clock" id="analogClock">
          <div class="hand hour" id="hourHand"></div>
          <div class="hand minute" id="minuteHand"></div>
          <div class="hand second" id="secondHand"></div>
          <div class="center-cap"></div>
        </div>
      </div>
    </div>
  `;

  const hourHand = target.querySelector('#hourHand');
  const minuteHand = target.querySelector('#minuteHand');
  const secondHand = target.querySelector('#secondHand');
  const analogClock = target.querySelector("#analogClock");

  function createNumbers(large = false, radius = 93) {
    for (let i = 1; i <= 12; i++) {
      const num = document.createElement("div");
      num.className = "clock-number";
      num.textContent = i;

      const angle = (i - 3) * 30;
      const x = 120 + radius * Math.cos(angle * Math.PI / 180);
      const y = 120 + radius * Math.sin(angle * Math.PI / 180);

      num.style.left = `${x}px`;
      num.style.top = `${y}px`;

      if (large && [3, 6, 9, 12].includes(i)) {
        num.classList.add("large");
      }

      analogClock.appendChild(num);
    }
  }

  function createTicks() {
    for (let i = 0; i < 60; i++) {
      const tick = document.createElement("div");
      tick.className = (i % 5 === 0) ? "tickHour" : "tick";
      tick.style.transform = `rotate(${i * 6}deg) translate(-50%, 0)`;
      analogClock.appendChild(tick);
    }
  }

  function updateAnalogClock() {
    const now = new Date();
    const ms = now.getMilliseconds();
    const sec = now.getSeconds() + ms / 1000;
    const min = now.getMinutes() + sec / 60;
    const hr = now.getHours() % 12 + min / 60;

    hourHand.style.transform = `rotate(${hr * 30}deg)`;
    minuteHand.style.transform = `rotate(${min * 6}deg)`;
    secondHand.style.transform = `rotate(${sec * 6}deg)`;

    requestAnimationFrame(updateAnalogClock);
  }

  createTicks();
  createNumbers(true);
  updateAnalogClock();

  target.querySelector("#clockScale").style.transform = "scale(0.5)";
}

function addAnalogClockStyle() {
  const style = document.createElement('style');
  style.textContent = `
    .itemBoxX {
      margin-top: 1px;
      box-sizing: border-box;
      display: flex;
      justify-content: center;
      align-items: center;
    
      width: 100%;
    }

    .clock-container {
      display: flex;
      flex-direction: column;
      justify-content: center;
      align-items: center;
      font-family: sans-serif;
      height: 100%;
      width: 100%;
      padding: 0;
      box-sizing: border-box;
    }

    .analog-clock {
      position: relative;
      width: 240px;
      height: 240px;
      border-radius: 50%;
      box-shadow: inset 0 0 15px rgba(0,0,0,0.3), 0 10px 20px rgba(0,0,0,0.4);
    }

    .hand {
      position: absolute;
      left: 50%;
      transform-origin: 50% 100%;
      bottom: 50%;
    }

    .hour { width: 8px; height: 55px; background: #222; margin-left: -4px; }
    .minute { width: 6px; height: 85px; background: #777; margin-left: -3px; }
    .second { width: 2px; height: 90px; background: red; margin-left: -1px; }

    .center-cap {
      position: absolute;
      width: 14px;
      height: 14px;
      background: red;
      border-radius: 50%;
      top: 50%; left: 50%;
      transform: translate(-50%, -50%);
      z-index: 10;
    }

    .tick, .tickHour {
      position: absolute;
      top: 0;
      left: 50%;
      transform-origin: center 120px;
      background: #ccc;
    }

    .tick { width: 2px; height: 8px; }
    .tickHour { width: 4px; height: 18px; background: #aaa; }

    .clock-number {
      position: absolute;
      transform: translate(-50%, -50%);
      font-size: 12px;
      color: #555;
    }

    .clock-number.large {
      font-size: 18px;
      font-weight: bold;
      color: #000;
    }
  `;
  document.head.appendChild(style);
}

addAnalogClockStyle();